/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.model.ui;

import com.cognos.mobile.client.IClientApplication;
import com.cognos.mobile.common.CMIDs;
import com.cognos.mobile.common.IResourceManager;
import com.cognos.mobile.model.ui.StringChoice;
import com.cognos.mobile.model.ui.StringChoiceResponse;
import com.cognos.mobile.vm.IVMCache;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMOptions;
import java.util.Vector;

public class PreferredSyncHelper {
    private static final Class CLASS = PreferredSyncHelper.class;

    public static StringChoiceResponse getPreferredSyncChoices(IResourceManager res, VMOptions options, IClientApplication clientApplication) {
        String supportedSyncMethods = clientApplication.getSupportedSyncMethods();
        Vector<StringChoice> v = new Vector<StringChoice>();
        StringChoiceResponse response = new StringChoiceResponse();
        int index = 0;
        response.selectedIndex = index++;
        if (supportedSyncMethods.indexOf("2") != -1) {
            v.addElement(new StringChoice(res.loadString(CMIDs.GEEKOPTIONS_SYNC_METHOD_S2), "2"));
            if (options.getPreferredSyncMethod().equals("2")) {
                response.selectedIndex = index;
            }
        }
        response.choices = new StringChoice[v.size()];
        v.copyInto(response.choices);
        return response;
    }

    public static String getEffectiveSyncMethod(VMOptions options, IClientApplication clientApplication, IVMCache cache) {
        String preferredSyncMethod = options.getPreferredSyncMethod();
        String supportedByClientPlatform = clientApplication.getSupportedSyncMethods();
        String availableFromServer = options.getSessionCookieProperty("asm");
        String havePermissionToUse = "M2";
        String effectiveSyncMethod = "M2";
        if (preferredSyncMethod != null && availableFromServer != null && availableFromServer.indexOf(preferredSyncMethod) != -1 && supportedByClientPlatform.indexOf(preferredSyncMethod) != -1 && havePermissionToUse.indexOf(preferredSyncMethod) != -1) {
            effectiveSyncMethod = preferredSyncMethod;
        }
        VM.log(CLASS, 0, "sync methods: available on server '" + availableFromServer + "'; supported by client '" + supportedByClientPlatform + "'; permission to use: " + havePermissionToUse + "; preferred '" + preferredSyncMethod + "'; effective '" + effectiveSyncMethod + "'");
        return effectiveSyncMethod;
    }
}

