/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.model.ui;

import com.cognos.mobile.common.CMIDs;
import com.cognos.mobile.common.IResourceManager;
import com.cognos.mobile.model.ui.IntChoice;
import com.cognos.mobile.model.ui.IntChoiceResponse;
import com.cognos.mobile.vm.VMOptions;

public class ZoomLevelHelper {
    public static IntChoice[] buildZoomChoiceList(IResourceManager resourceManager) {
        IntChoice[] zoomList = new IntChoice[15];
        zoomList[0] = new IntChoice(resourceManager.loadString(CMIDs.OPTIONS_FIT_TO_WIDTH), -1);
        zoomList[1] = new IntChoice(resourceManager.loadString(CMIDs.OPTIONS_FIT_TO_PAGE), -2);
        int zoom = 0;
        for (int i = 2; i < zoomList.length; ++i) {
            int realZoom = Math.max(10, zoom);
            realZoom = Math.min(300, realZoom);
            String label = resourceManager.formatString(CMIDs.OPTIONS_ZOOM_N_PERCENT, Integer.toString(realZoom));
            zoomList[i] = new IntChoice(label, realZoom);
            zoom += 25;
        }
        return zoomList;
    }

    public static IntChoiceResponse buildPageInitialZoomList(IntChoice[] zoomList, IResourceManager resourceManager, VMOptions options) {
        IntChoiceResponse response = new IntChoiceResponse();
        if (zoomList == null) {
            zoomList = ZoomLevelHelper.buildZoomChoiceList(resourceManager);
        }
        response.choices = zoomList;
        response.selectByValue(options.getPageInitialZoom());
        return response;
    }

    public static IntChoiceResponse buildTextInitialZoomList(IntChoice[] zoomList, IResourceManager resourceManager, VMOptions options) {
        IntChoiceResponse response = new IntChoiceResponse();
        if (zoomList == null) {
            zoomList = ZoomLevelHelper.buildZoomChoiceList(resourceManager);
        }
        response.choices = zoomList;
        response.selectByValue(options.getTextInitialZoom());
        return response;
    }

    public static IntChoiceResponse buildImageInitialZoomList(IntChoice[] zoomList, IResourceManager resourceManager, VMOptions options) {
        IntChoiceResponse response = new IntChoiceResponse();
        if (zoomList == null) {
            zoomList = ZoomLevelHelper.buildZoomChoiceList(resourceManager);
        }
        response.choices = zoomList;
        response.selectByValue(options.getImageInitialZoom());
        return response;
    }
}

