/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.prompts;

import com.cognos.mobile.prompts.Prompt;
import com.cognos.mobile.prompts.PromptsContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class BasePromptHandler
extends DefaultHandler {
    private final PromptsContentHandler conversationHandler;
    private Prompt prompt;
    private boolean selections;
    private String optionKey;
    private String optionValue;
    private boolean rangeSelections;
    private String startOptionKey;
    private String startOptionValue;
    private String endOptionKey;
    private String endOptionValue;

    public BasePromptHandler(PromptsContentHandler conversationHandler) {
        this.conversationHandler = conversationHandler;
    }

    public final void setPrompt(Prompt prompt) {
        this.prompt = prompt;
        this.captureText(false);
    }

    public final PromptsContentHandler getConversationHandler() {
        return this.conversationHandler;
    }

    public final void captureText(boolean b) {
        this.conversationHandler.captureText(b);
    }

    public final void commitPrompt() {
        this.conversationHandler.addPromptItem(this.prompt);
        this.prompt = null;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (this.prompt == null) {
            return;
        }
        if (localName.equals("selections")) {
            this.conversationHandler.captureText(false);
            this.selections = true;
        } else if (localName.equals("rangeOptions")) {
            this.rangeSelections = true;
            this.selections = true;
        } else if (localName.equals("autoSubmit") || localName.equals("name") || localName.equals("columnName") || localName.equals("range") || localName.equals("multiSelect") || localName.equals("required") || this.selections && (localName.equals("useValue") || localName.equals("displayValue"))) {
            this.conversationHandler.captureText(true);
        } else {
            this.conversationHandler.captureText(false);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qname) throws SAXException {
        if (this.prompt == null) {
            return;
        }
        if (localName.equals("autoSubmit")) {
            this.prompt.setAuto(this.conversationHandler.getText().startsWith("t"));
        } else if (localName.equals("columnName")) {
            this.prompt.setColumnName(this.conversationHandler.getText());
        } else if (localName.equals("name")) {
            this.prompt.setName(this.conversationHandler.getText());
        } else if (localName.equals("range")) {
            this.prompt.setRange(this.conversationHandler.getText().startsWith("t"));
        } else if (localName.equals("multiSelect")) {
            this.prompt.setMultiSelect(this.conversationHandler.getText().startsWith("t"));
        } else if (localName.equals("required")) {
            this.prompt.setRequired(this.conversationHandler.getText().startsWith("t"));
        } else if (this.rangeSelections && localName.equals("start")) {
            this.startOptionKey = this.optionKey;
            this.startOptionValue = this.optionValue;
        } else if (this.rangeSelections && localName.equals("end")) {
            this.endOptionKey = this.optionKey;
            this.endOptionValue = this.optionValue;
        } else if (localName.equals("rangeOptions")) {
            this.prompt.addRangeSelection(this.startOptionKey, this.startOptionValue, this.endOptionKey, this.endOptionValue);
            this.startOptionKey = null;
            this.startOptionValue = null;
            this.endOptionKey = null;
            this.endOptionValue = null;
        } else if (localName.equals("rangeSelections")) {
            this.rangeSelections = false;
        } else if (this.selections && localName.equals("useValue")) {
            this.optionKey = this.conversationHandler.getText();
        } else if (this.selections && localName.equals("displayValue")) {
            this.optionValue = this.conversationHandler.getText();
            if (this.optionValue.length() == 0) {
                this.optionValue = this.optionKey;
            }
        } else if (localName.equals("selections")) {
            this.selections = false;
        } else if (this.isCapturingOptions() && localName.equals("options")) {
            this.prompt.addSelection(this.optionKey, this.optionValue);
            this.optionKey = null;
            this.optionValue = null;
        }
    }

    public String getText() {
        return this.conversationHandler.getText();
    }

    public boolean isCapturingOptions() {
        return this.selections;
    }
}

