/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.prompts;

import com.cognos.mobile.prompts.Prompt;
import com.cognos.mobile.prompts.Prompts;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Conversation {
    private final String id;
    private final Prompts starter;
    private final Vector prompts;

    public Conversation(Prompts p) {
        this.id = p.getConversationId() != null ? p.getConversationId() : null;
        this.starter = p;
        this.prompts = new Vector();
        this.prompts.addElement(p);
    }

    public final String getId() {
        return this.id;
    }

    public void add(Prompts p) {
        Hashtable<Prompt, Prompts> consolidator = new Hashtable<Prompt, Prompts>();
        for (int i = 0; i < this.prompts.size(); ++i) {
            Prompts oldPrompts = (Prompts)this.prompts.elementAt(i);
            Prompt[] oldItems = oldPrompts.listPromptItems();
            for (int j = 0; j < oldItems.length; ++j) {
                consolidator.put(oldItems[j], oldPrompts);
            }
        }
        Prompt[] newItems = p.listPromptItems();
        for (int i = 0; i < newItems.length; ++i) {
            if (!consolidator.containsKey(newItems[i])) continue;
            Prompts oldPrompts = (Prompts)consolidator.get(newItems[i]);
            oldPrompts.remove(newItems[i]);
            if (oldPrompts.listPromptItems().length != 0) continue;
            this.prompts.removeElement(oldPrompts);
        }
        if (this.id != null && p.getConversationId().equals(this.starter.getConversationId())) {
            this.prompts.addElement(p);
        }
    }

    public void replace(int page, Prompts p) {
        this.prompts.removeElementAt(page);
        this.prompts.insertElementAt(p, page);
    }

    public Prompts getPage(int page) {
        return (Prompts)this.prompts.elementAt(page);
    }

    public final String asPromptAnswers() {
        StringBuffer buff = new StringBuffer("<promptAnswers xmlns=\"http://developer.cognos.com/schemas/rds/types/2\">");
        Enumeration en = this.prompts.elements();
        while (en.hasMoreElements()) {
            Prompts p = (Prompts)en.nextElement();
            buff.append(p.asPromptAnswers());
        }
        if (this.id != null) {
            buff.append("<conversationID>" + this.id + "</conversationID>");
        }
        buff.append("</promptAnswers>");
        return buff.toString();
    }
}

