/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.prompts;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.prompts.Prompt;
import com.cognos.mobile.xml.XMLHelper;
import java.util.Enumeration;
import java.util.Vector;

public class PDataSource
extends Prompt {
    private String connName;
    private String connSearchPath;
    private boolean connSelected;
    private String dataSourceName;
    private String faultcode;
    private String faultstring;
    private Vector signons = new Vector();

    public final String getFaultcode() {
        return this.faultcode;
    }

    public final void setFaultcode(String faultcode) {
        this.faultcode = faultcode;
    }

    public final String getFaultstring() {
        return this.faultstring;
    }

    public final void setFaultstring(String faultstring) {
        this.faultstring = faultstring;
    }

    public final String getDataSourceName() {
        return this.dataSourceName;
    }

    public final void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    @Override
    public final String getTag() {
        return "PDataSource";
    }

    public static Signon createSignon() {
        return new Signon();
    }

    public void addSignon(Signon signon) {
        this.signons.addElement(signon);
    }

    public String[] listSignons() {
        String[] v = new String[this.signons.size()];
        Enumeration en = this.signons.elements();
        int i = 0;
        while (en.hasMoreElements()) {
            v[i++] = ((Signon)en.nextElement()).getName();
        }
        return v;
    }

    public String getConnectionName() {
        return this.connName;
    }

    public String getConnectionSearchPath() {
        return this.connSearchPath;
    }

    public boolean isConnectionSelected() {
        return this.connSelected;
    }

    public void setConnectionSelected(boolean dsc) {
        this.connSelected = dsc;
    }

    public void setConnectionName(String dsc) {
        this.connName = dsc;
    }

    public void setConnectionSearchPath(String dsc) {
        this.connSearchPath = dsc;
    }

    @Override
    public boolean isAcceptable(Object value) throws CMException {
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            Signon s = this.getSignon((String)value);
            if (s == null) {
                throw new IllegalArgumentException("No signon named: " + value);
            }
            return true;
        }
        if (value instanceof String[]) {
            return true;
        }
        throw new IllegalArgumentException("PDataSource only accepts String and String[]");
    }

    @Override
    public Object createAcceptableValueFromString(String s) {
        return s;
    }

    private String toCAMCredential(String[] v) {
        StringBuffer buff = new StringBuffer();
        buff.append("<credential><dataSourceConnection>" + this.connSearchPath + "</dataSourceConnection>");
        buff.append("<username>" + v[0] + "</username>");
        buff.append("<password>" + v[1] + "</password></credential>");
        return buff.toString();
    }

    public Signon getSignon(String name) {
        if (this.signons.size() == 1) {
            return (Signon)this.signons.elementAt(0);
        }
        Enumeration en = this.signons.elements();
        while (en.hasMoreElements()) {
            Signon s = (Signon)en.nextElement();
            if (!(s.getName() != null ? s.getName().equals(name) : name == null)) continue;
            return s;
        }
        return null;
    }

    private String toCAMCredential(String v) {
        StringBuffer buff = new StringBuffer();
        buff.append("<credential><dataSourceConnection>" + this.connSearchPath + "</dataSourceConnection>");
        Signon s = this.getSignon(v);
        buff.append("<dataSourceSignon>" + s.getSearchPath() + "</dataSourceSignon></credential>");
        return buff.toString();
    }

    @Override
    public String toPromptAnswers(Object value) {
        boolean empty = true;
        StringBuffer buff = new StringBuffer();
        buff.append("<values>");
        if (!PDataSource.isNull(value)) {
            empty = false;
            buff.append("<item><SimplePValue><inclusive>true</inclusive><useValue>");
            if (value instanceof String[]) {
                buff.append(XMLHelper.encodeXml(this.toCAMCredential((String[])value)));
            } else {
                buff.append(XMLHelper.encodeXml(this.toCAMCredential((String)value)));
            }
            buff.append("</useValue></SimplePValue></item>");
        }
        buff.append("</values>");
        buff.append("</promptValues>");
        buff.insert(0, this.createPromptValues(empty));
        return buff.toString();
    }

    @Override
    public final int type() {
        return 4;
    }

    @Override
    public String toString() {
        return super.toString() + PDataSource.toStringEntry("connection", XMLHelper.encodeXml(this.getConnectionSearchPath()));
    }

    public static class Signon {
        private String name;
        private String searchPath;
        private boolean selected;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getSearchPath() {
            return this.searchPath;
        }

        public void setSearchPath(String searchPath) {
            this.searchPath = searchPath;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }
    }
}

