/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.prompts;

import com.cognos.mobile.prompts.PDataSource;
import com.cognos.mobile.prompts.PromptsContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PDataSourceHandler
extends DefaultHandler {
    public static final String ELEMENT = "PDataSource";
    private PDataSource box;
    private final PromptsContentHandler conversationHandler;
    private boolean inConnection;
    private boolean inSignon;
    private PDataSource.Signon activeSignon;

    PDataSourceHandler(PromptsContentHandler conversationHandler) {
        this.conversationHandler = conversationHandler;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (localName.equals(ELEMENT)) {
            this.box = new PDataSource();
            this.conversationHandler.captureText(false);
        } else if (localName.equals("name") || localName.equals("searchPath") || localName.equals("selected")) {
            this.conversationHandler.captureText(true);
        } else if (localName.equals("connection")) {
            this.inConnection = true;
        } else if (localName.equals("signon")) {
            this.inSignon = true;
            this.activeSignon = PDataSource.createSignon();
        } else {
            this.conversationHandler.captureText(false);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qname) throws SAXException {
        if (localName.equals(ELEMENT)) {
            this.conversationHandler.addPromptItem(this.box);
        } else if (localName.equals("name")) {
            if (this.inConnection) {
                this.box.setConnectionName(this.conversationHandler.getText());
            } else if (this.inSignon) {
                this.activeSignon.setName(this.conversationHandler.getText());
            } else {
                this.box.setName(this.conversationHandler.getText());
            }
        } else if (localName.equals("searchPath")) {
            if (this.inConnection) {
                this.box.setConnectionSearchPath(this.conversationHandler.getText());
            } else if (this.inSignon) {
                this.activeSignon.setSearchPath(this.conversationHandler.getText());
            }
        } else if (localName.equals("selected")) {
            if (this.inConnection) {
                this.box.setConnectionSelected(this.conversationHandler.getText().startsWith("t"));
            } else if (this.inSignon) {
                this.activeSignon.setSelected(this.conversationHandler.getText().startsWith("t"));
            }
        } else if (localName.equals("connection")) {
            this.inConnection = false;
        } else if (localName.equals("signon")) {
            this.inSignon = false;
            if (this.activeSignon.getName() != null) {
                this.box.addSignon(this.activeSignon);
            }
            this.activeSignon = null;
        }
    }
}

