/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.prompts;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.prompts.Prompt;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class PDateTimeBox
extends Prompt {
    public static final String DATE = "DATE";
    public static final String TIME = "TIME";
    public static final String DATETIME = "DATETIME";
    public static final String INTERVAL = "INTERVAL";
    public static final int DAYS = 0;
    public static final int HOURS = 1;
    public static final int MINUTES = 2;
    public static final int SECONDS = 3;
    public static final int MILLISECONDS = 4;
    public static final String GREGORIAN = "GREGORIAN";
    public static final String IMPERIAL = "IMPERIAL";
    private String valueType;
    private String calendarType;
    private boolean displaySeconds;
    private boolean displayMilliSeconds;
    private Date firstDate;
    private Date lastDate;
    private String dateUI;
    private String timeUI;
    private String cmode;
    private static final String DATETIMEFORMAT_USE = "yyyy-MM-ddTHH:mm:ss.SSS";
    private static final String DATETIMEFORMAT2_USE = "yyyy-MM-ddTHH:mm:ss";
    private static final String DATETIMEFORMAT3_USE = "yyyy-MM-ddTHH:mm:ss";
    private static final String DATETIMEFORMAT2 = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String DATEFORMAT = "yyyy-MM-dd";
    private static final String TIMEFORMAT = "HH:mm:ss.SSS";
    private static final String INTERVALFORMAT = "' 'HH:mm:ss.SSS";
    private static final String INTERVALFORMAT_USE = "'DT'h'H'm'M's.SSS'S'";
    public static final int[] CALENDAR_FIELDS_SEC_MILLI = new int[]{13, 14};
    public static final int[] CALENDAR_FIELDS_MILLI = new int[]{14};

    public PDateTimeBox(String valueType) {
        this.valueType = valueType;
    }

    public PDateTimeBox() {
    }

    @Override
    public final String getTag() {
        if (this.valueType != null) {
            if (this.valueType == DATE) {
                return "PDate";
            }
            if (this.valueType == TIME) {
                return "PTime";
            }
            if (this.valueType == DATETIME) {
                return "PDTime";
            }
            if (this.valueType == INTERVAL) {
                return "PIntrvl";
            }
        }
        return "PDTime";
    }

    public final void setValueType(String valueType) {
        this.valueType = valueType.intern();
    }

    public final void setCalendarType(String calendarType) {
        this.calendarType = calendarType.intern();
    }

    public final void setDisplaySeconds(boolean displaySeconds) {
        this.displaySeconds = displaySeconds;
    }

    public final void setDisplayMilliSeconds(boolean displayMilliSeconds) {
        this.displayMilliSeconds = displayMilliSeconds;
    }

    public final void setFirstDate(Date firstDate) {
        this.firstDate = firstDate;
    }

    public final void setLastDate(Date lastDate) {
        this.lastDate = lastDate;
    }

    @Override
    public final int type() {
        return 3;
    }

    public void setDateUI(String ui) {
        this.dateUI = ui;
    }

    public String getDateUI() {
        return this.dateUI;
    }

    public void setTimeUI(String ui) {
        this.timeUI = ui;
    }

    public String getTimeUI() {
        return this.timeUI;
    }

    public void setClockMode(String ui) {
        this.cmode = ui;
    }

    public String getClockMode() {
        return this.cmode;
    }

    public final Date[] getDefaultsValuesAsDates() {
        Hashtable selections = this.getDefaults();
        if (selections == null || selections.size() == 0) {
            return new Date[0];
        }
        Date[] result = new Date[selections.size()];
        int i = 0;
        Enumeration en = selections.elements();
        while (en.hasMoreElements()) {
            String value = (String)en.nextElement();
            if (this.getValueType() == INTERVAL) {
                result[i++] = PDateTimeBox.parseInterval(value);
                continue;
            }
            if (this.getValueType() == TIME) {
                result[i++] = CMStringHelper.parseTime(value);
                continue;
            }
            result[i++] = CMStringHelper.parseDateTime(value);
        }
        return result;
    }

    public final String getValueType() {
        return this.valueType;
    }

    public final String getCalendarType() {
        return this.calendarType;
    }

    public final boolean isDisplaySeconds() {
        return this.displaySeconds;
    }

    public final boolean isDisplayMilliSeconds() {
        return this.displayMilliSeconds;
    }

    public final Date getFirstDate() {
        return this.firstDate;
    }

    public final Date getLastDate() {
        return this.lastDate;
    }

    @Override
    public boolean isAcceptable(Object value) throws CMException {
        Date[] d;
        if (PDateTimeBox.isNull(value)) {
            if (this.isRequired()) {
                throw new CMException(1404, new String[]{this.getLabel()});
            }
            return true;
        }
        if (value instanceof Date[]) {
            d = (Date[])value;
        } else if (value instanceof Date) {
            d = new Date[]{(Date)value};
        } else {
            throw new IllegalArgumentException("PDateTimeBox accepts Date[] only");
        }
        if (this.isRequired() && (d.length == 0 || this.isRange() && d.length != 2)) {
            throw new CMException(1404, new String[]{this.getLabel()});
        }
        if (this.isRange() && this.getValueType() != INTERVAL && d.length == 2 && PDateTimeBox.after(d[0], d[1])) {
            throw new CMException(1403, new String[]{this.getLabel(), this.toString(d[1])});
        }
        if (this.isRequired() && this.getValueType() == INTERVAL && d[0].getTime() == 0L) {
            throw new CMException(1404, new String[]{this.getLabel()});
        }
        for (int i = 0; i < d.length; ++i) {
            if (!PDateTimeBox.before(d[i], this.getFirstDate()) && !PDateTimeBox.after(d[i], this.getLastDate())) continue;
            throw new CMException(1400, new String[]{this.getLabel(), this.toString(this.getFirstDate()), this.toString(this.getLastDate())});
        }
        return true;
    }

    @Override
    public Object createAcceptableValueFromString(String s) {
        return CMStringHelper.parseDate(s);
    }

    public static boolean after(Date d1, Date d2) {
        return d1.getTime() > d2.getTime();
    }

    public static boolean before(Date d1, Date d2) {
        return d1.getTime() < d2.getTime();
    }

    @Override
    public final String toPromptAnswers(Object value) {
        StringBuffer buff = new StringBuffer();
        buff.append("<values>");
        boolean allEmpty = true;
        if (PDateTimeBox.isNull(value)) {
            if (this.isRequired()) {
                return "";
            }
        } else {
            Date[] v = value instanceof Date ? new Date[]{(Date)value} : (Date[])value;
            StringBuffer tempBuff = new StringBuffer();
            for (int i = 0; i < v.length; ++i) {
                Date start;
                tempBuff.append("<item>");
                PDateTimeBox box = this;
                if (box.isRange() && v.length > i + 1) {
                    Date end;
                    tempBuff.append("<RangePValue>");
                    tempBuff.append("<inclusive>true</inclusive>");
                    start = v[i++];
                    if (start != null && start.getTime() > Long.MIN_VALUE) {
                        tempBuff.append("<start>");
                        if (start.toString().length() != 0) {
                            allEmpty = false;
                        }
                        tempBuff.append("<inclusive>true</inclusive><useValue>" + this.toLongString(start) + "</useValue>");
                        tempBuff.append("</start>");
                    }
                    if ((end = v[i]) != null && end.getTime() > Long.MIN_VALUE) {
                        if (end.toString().length() != 0) {
                            allEmpty = false;
                        }
                        tempBuff.append("<end>");
                        tempBuff.append("<inclusive>true</inclusive><useValue>" + this.toLongString(end) + "</useValue>");
                        tempBuff.append("</end>");
                        tempBuff.append("</RangePValue>");
                    }
                } else {
                    start = v[i];
                    if (start != null && start.getTime() > Long.MIN_VALUE) {
                        if (start.toString().length() != 0) {
                            allEmpty = false;
                        }
                        tempBuff.append("<SimplePValue>");
                        tempBuff.append("<inclusive>true</inclusive><useValue>" + this.toLongString(start) + "</useValue>");
                        tempBuff.append("</SimplePValue>");
                    }
                }
                tempBuff.append("</item>");
            }
            if (this.isRequired()) {
                buff.append(tempBuff.toString());
            } else if (!allEmpty) {
                buff.append(tempBuff.toString());
            }
        }
        buff.append("</values>");
        buff.append("</promptValues>");
        buff.insert(0, this.createPromptValues(allEmpty));
        return buff.toString();
    }

    public static Date toDate(String s) {
        return CMStringHelper.parseDateTime(s);
    }

    public String toLongString(Date date) {
        date = this.zeroOutFields(date);
        if (this.getValueType() == INTERVAL) {
            return "P" + PDateTimeBox.formatInterval(date, INTERVALFORMAT_USE);
        }
        if (this.getValueType() == TIME) {
            return CMStringHelper.format(date, TIMEFORMAT).toString();
        }
        if (this.getValueType() == DATE) {
            return CMStringHelper.format(date, DATEFORMAT).toString() + "T00:00:00";
        }
        if (this.displayMilliSeconds) {
            return CMStringHelper.format(date, DATETIMEFORMAT_USE).toString();
        }
        if (this.displaySeconds) {
            return CMStringHelper.format(date, "yyyy-MM-ddTHH:mm:ss").toString();
        }
        return CMStringHelper.format(date, "yyyy-MM-ddTHH:mm:ss").toString();
    }

    public String toString(Date date) {
        date = this.zeroOutFields(date);
        if (this.getValueType() == INTERVAL) {
            return PDateTimeBox.formatInterval(date, INTERVALFORMAT);
        }
        if (this.getValueType() == DATE) {
            return CMStringHelper.format(date, DATEFORMAT).toString();
        }
        if (this.getValueType() == TIME) {
            return CMStringHelper.format(date, TIMEFORMAT).toString();
        }
        return CMStringHelper.format(date, DATETIMEFORMAT2).toString();
    }

    public Date parse(String key) {
        if (this.getValueType() == INTERVAL) {
            return PDateTimeBox.parseInterval(key);
        }
        if (this.getValueType() == TIME) {
            return CMStringHelper.parseTime(key);
        }
        return CMStringHelper.parseDateTime(key);
    }

    public Date zeroOutFields(Date d) {
        if (this.getValueType() == DATE) {
            return PDateTimeBox.zeroFields(d, CALENDAR_FIELDS_SEC_MILLI);
        }
        if (!this.isRange() && !this.displaySeconds) {
            return PDateTimeBox.zeroFields(d, CALENDAR_FIELDS_SEC_MILLI);
        }
        if (!this.isRange() && !this.displayMilliSeconds) {
            return PDateTimeBox.zeroFields(d, CALENDAR_FIELDS_MILLI);
        }
        return d;
    }

    public static Date parseInterval(String key) {
        Date d;
        int where;
        boolean PFormat;
        boolean bl = PFormat = key.charAt(0) == 'P';
        if (PFormat) {
            String conversion = key;
            conversion = CMStringHelper.replaceAll(conversion, "P", "", false);
            conversion = CMStringHelper.replaceAll(conversion, "DT", " ", false);
            conversion = CMStringHelper.replaceAll(conversion, "H", ":", false);
            if (key.indexOf("S") != -1) {
                conversion = CMStringHelper.replaceAll(conversion, "M", ":", false);
                conversion = CMStringHelper.replaceAll(conversion, "S", "", false);
            } else {
                conversion = CMStringHelper.replaceAll(conversion, "M", "", false);
            }
            key = conversion;
        }
        if ((where = key.indexOf(32)) > 0) {
            String s = key.substring(where).trim();
            d = CMStringHelper.parseTime(s);
            long days = Integer.parseInt(key.substring(0, where).trim());
            long time = PDateTimeBox.getTimeInMillis(d);
            d.setTime(days * 86400000L + time);
        } else {
            d = CMStringHelper.parseTime(key);
        }
        return d;
    }

    public static Date getTimeFromInterval(Date d) {
        long days = PDateTimeBox.getDaysFromInterval(d);
        long time = d.getTime() - days * 86400000L;
        long hours = time / 3600000L;
        String h = "" + hours;
        if (hours < 10L) {
            h = "0" + hours;
        }
        long remaining = time - hours * 3600000L;
        long mins = remaining / 60000L;
        String m = "" + mins;
        if (mins < 10L) {
            m = "0" + mins;
        }
        long secs = (remaining -= mins * 60000L) / 1000L;
        String s = "" + secs;
        if (secs < 10L) {
            s = "0" + secs;
        }
        String ms = "" + (remaining -= secs * 1000L);
        if (remaining < 10L) {
            ms = "00" + remaining;
        } else if (remaining < 100L) {
            ms = "0" + remaining;
        }
        return CMStringHelper.parseTime(h + ":" + m + ":" + s + "." + ms);
    }

    public static String formatInterval(Date d, String timeFormat) {
        int days = (int)PDateTimeBox.getDaysFromInterval(d);
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return days + CMStringHelper.format(PDateTimeBox.getTimeFromInterval(d), timeFormat);
    }

    public static long getDaysFromInterval(Date d) {
        return d.getTime() / 86400000L;
    }

    public static String[] intervalToArray(String s) {
        Date def = null;
        String[] values = new String[5];
        for (int i = 0; i < values.length; ++i) {
            values[i] = "";
        }
        if (s == null) {
            return values;
        }
        if (s != null && s.length() > 0) {
            def = PDateTimeBox.parseInterval(s);
        }
        if (def != null) {
            Date time = PDateTimeBox.getTimeFromInterval(def);
            Calendar c = Calendar.getInstance();
            c.setTime(time);
            for (int i = 0; i < values.length; ++i) {
                int value = 0;
                switch (i) {
                    case 0: {
                        value = (int)PDateTimeBox.getDaysFromInterval(def);
                        break;
                    }
                    case 1: {
                        value = c.get(11);
                        break;
                    }
                    case 2: {
                        value = c.get(12);
                        break;
                    }
                    case 3: {
                        value = c.get(13);
                        break;
                    }
                    case 4: {
                        value = c.get(14);
                    }
                }
                values[i] = Integer.toString(value);
            }
        }
        return values;
    }

    public static long getTimeInMillis(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.get(11) * 3600000 + c.get(12) * 60000 + c.get(13) * 1000 + c.get(14);
    }

    public static Date zeroFields(Date d, int[] fields) {
        if (fields == null) {
            fields = CALENDAR_FIELDS_SEC_MILLI;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        for (int i = 0; i < fields.length; ++i) {
            c.set(fields[i], 0);
        }
        return c.getTime();
    }

    @Override
    public String toString() {
        return super.toString() + PDateTimeBox.toStringEntry("displayseconds", this.isDisplaySeconds()) + PDateTimeBox.toStringEntry("displaymilliseconds", this.isDisplayMilliSeconds()) + PDateTimeBox.toStringEntry("clndr", this.getCalendarType()) + PDateTimeBox.toStringEntry("dateui", this.getDateUI()) + PDateTimeBox.toStringEntry("dvalue", this.getDefaultValue()) + (this.getValueType() == TIME ? PDateTimeBox.toStringEntry("cmode", this.getClockMode()) : "");
    }
}

