/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.prompts;

import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.prompts.BasePromptHandler;
import com.cognos.mobile.prompts.PDateTimeBox;
import com.cognos.mobile.prompts.PromptsContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class PDateTimeBoxHandler
extends BasePromptHandler {
    public static final String ELEMENT = "PDateTimeBox";
    private PDateTimeBox box;

    PDateTimeBoxHandler(PromptsContentHandler conversationHandler) {
        super(conversationHandler);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (localName.equals(ELEMENT)) {
            this.box = new PDateTimeBox();
            this.setPrompt(this.box);
        } else if (localName.equals("valueType") || localName.equals("calendarType") || localName.equals("displaySeconds") || localName.equals("displayMilliSeconds") || localName.equals("firstDate") || localName.equals("lastDate")) {
            this.captureText(true);
        } else {
            super.startElement(uri, localName, name, attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qname) throws SAXException {
        if (localName.equals(ELEMENT)) {
            this.commitPrompt();
        } else if (localName.equals("valueType")) {
            this.box.setValueType(this.getText());
        } else if (localName.equals("calendarType")) {
            this.box.setCalendarType(this.getText());
        } else if (localName.equals("displaySeconds")) {
            this.box.setDisplaySeconds(this.getText().startsWith("t"));
        } else if (localName.equals("displayMilliSeconds")) {
            this.box.setDisplayMilliSeconds(this.getText().startsWith("t"));
        } else if (localName.equals("firstDate")) {
            this.box.setFirstDate(CMStringHelper.parseDateTime(this.getText() + " 00:00:0.000"));
        } else if (localName.equals("lastDate")) {
            this.box.setLastDate(CMStringHelper.parseDateTime(this.getText() + " 23:59:59.999"));
        } else {
            super.endElement(uri, localName, qname);
        }
    }
}

