/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.prompts;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMLinkedHashtable;
import com.cognos.mobile.prompts.Prompt;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.xml.XMLHelper;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PListBox
extends Prompt {
    private static final Class CLASS = PListBox.class;
    private final CMLinkedHashtable options = new CMLinkedHashtable();
    private final Vector values = new Vector();
    private String cascadeOn;
    private boolean prePopulate;
    private boolean disabled;
    private boolean autoCascade;
    private String selectUI;

    public void setSelectUI(String ui) {
        this.selectUI = ui;
    }

    public String getSelectUI() {
        return this.selectUI;
    }

    public void setPrePopulate(boolean b) {
        this.prePopulate = b;
    }

    public boolean getPrePopulate() {
        return this.prePopulate;
    }

    @Override
    public final int type() {
        return 2;
    }

    @Override
    public final String getTag() {
        return "PValue";
    }

    public final String getCascadeOn() {
        return this.cascadeOn;
    }

    public final void setCascadeOn(String cascadeOn) {
        this.cascadeOn = cascadeOn;
    }

    public final boolean isDisabled() {
        return this.disabled;
    }

    public final void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public final boolean isAutoCascade() {
        return this.autoCascade;
    }

    public final void setAutoCascade(boolean autoCascade) {
        this.autoCascade = autoCascade;
    }

    public void addOption(String useValue, String displayValue) {
        this.options.put(displayValue, useValue);
        if (!this.values.contains(displayValue)) {
            this.values.addElement(displayValue);
        }
    }

    public final Hashtable getOptions() {
        return this.options;
    }

    public String getDisplayValue(String useValue) {
        if (useValue == null || useValue.trim().length() == 0) {
            return null;
        }
        String dispValue = (String)this.options.keyOfValue(useValue);
        return dispValue;
    }

    public String getUseValue(String displayValue) {
        if (displayValue == null || displayValue.trim().length() == 0) {
            return null;
        }
        if (this.options.containsKey(displayValue)) {
            return (String)this.options.get(displayValue);
        }
        return null;
    }

    public Prompt.Range getRangeSelection() {
        Prompt.Range r = this.getDefaultRange();
        if (r == null) {
            Hashtable selections = this.getDefaults();
            if (selections != null) {
                this.addSelectionsToRangeSelections(selections);
                r = this.getDefaultRange();
            } else {
                return new Prompt.Range(null, null, null, null);
            }
        }
        return new Prompt.Range(r.getStartUseValue(), r.getStartDisplayValue(), r.getEndUseValue(), r.getEndDisplayValue());
    }

    public Prompt.Range[] getRangeSelections() {
        Hashtable selections;
        Prompt.Range[] r = this.getDefaultRanges();
        if (r.length <= 0 && (selections = this.getDefaults()) != null) {
            this.addSelectionsToRangeSelections(selections);
            r = this.getDefaultRanges();
        }
        return r;
    }

    private void addSelectionsToRangeSelections(Hashtable selections) {
        Enumeration keys = selections.keys();
        while (keys.hasMoreElements()) {
            String dispVal = (String)keys.nextElement();
            String useVal = (String)selections.get(dispVal);
            boolean keyMatch = this.options.containsKey(dispVal);
            boolean valueMatch = this.options.contains(useVal);
            if (keyMatch && !valueMatch) {
                useVal = this.getUseValue(dispVal);
            } else if (!keyMatch && valueMatch) {
                dispVal = this.getDisplayValue(useVal);
            }
            this.addRangeSelection(useVal, dispVal, useVal, dispVal);
        }
    }

    public final String[] listValues() {
        String[] v = new String[this.values.size()];
        Enumeration en = this.values.elements();
        int i = 0;
        while (en.hasMoreElements()) {
            v[i++] = (String)en.nextElement();
        }
        return v;
    }

    @Override
    public boolean isAcceptable(Object value) throws CMException {
        if (!this.isRequired() && value == null) {
            return true;
        }
        if (!(value instanceof String[])) {
            throw new IllegalArgumentException("PListBox accepts String[] only");
        }
        String[] v = (String[])value;
        if (this.isRange()) {
            if (this.isRange() && v.length < 2) {
                throw new IllegalArgumentException("PListBox isRange() is true but the String[] value doesn't have the minimum 2 elements.");
            }
            if (PListBox.isNull(v[0]) && PListBox.isNull(v[1]) && this.isRequired()) {
                throw new CMException(1404, new String[]{this.getLabel()});
            }
        } else if (PListBox.isNull(value)) {
            if (this.isRequired()) {
                throw new CMException(1404, new String[]{this.getLabel()});
            }
            return true;
        }
        if (this.isRequired() && v.length == 0 || value == null) {
            throw new CMException(1404, new String[]{this.getName()});
        }
        if (this.isMultiSelect() && this.isRange()) {
            throw new IllegalArgumentException("PListBox doesn't make sense if isMultiSelect() and isRange() are both true.  Check prompt data.");
        }
        for (int i = 0; i < v.length; ++i) {
            if (PListBox.isNull(v[i]) || this.options.containsKey(v[i])) continue;
            throw new CMException(1405, new String[]{v[i], this.getName()});
        }
        return true;
    }

    @Override
    public Object createAcceptableValueFromString(String s) {
        return new String[]{s};
    }

    @Override
    public final String toPromptAnswers(Object value) {
        VM.log(CLASS, 0, "value: " + value);
        StringBuffer buff = new StringBuffer();
        buff.append("<values>");
        boolean allEmpty = true;
        if (PListBox.isNull(value)) {
            VM.log(CLASS, 0, "value is seen as null");
            VM.log(CLASS, 0, "strange length: " + ((String[])value).length);
            VM.log(CLASS, 0, "strange length: " + ((String[])value)[0]);
            if (value == null) {
                return "";
            }
        } else {
            String[] v = (String[])value;
            StringBuffer tempBuff = new StringBuffer();
            for (int i = 0; i < v.length; ++i) {
                String useValue = (String)this.options.get(v[i]);
                tempBuff.append("<item>");
                PListBox box = this;
                if (box.isRange() && v.length > i + 1) {
                    tempBuff.append("<RangePValue>");
                    tempBuff.append("<inclusive>true</inclusive>");
                    String start = v[i++];
                    if (start != null) {
                        tempBuff.append("<start>");
                        if (start.length() != 0) {
                            allEmpty = false;
                        }
                        tempBuff.append("<inclusive>true</inclusive><useValue>" + start + "</useValue>");
                        tempBuff.append("</start>");
                    } else {
                        tempBuff.append("<start>");
                        tempBuff.append("<inclusive>true</inclusive><useValue>" + this.options.getFirstValue() + "</useValue>");
                        tempBuff.append("</start>");
                    }
                    String end = v[i];
                    if (end != null) {
                        if (end.toString().length() != 0) {
                            allEmpty = false;
                        }
                        tempBuff.append("<end>");
                        tempBuff.append("<inclusive>true</inclusive><useValue>" + end + "</useValue>");
                        tempBuff.append("</end>");
                        tempBuff.append("</RangePValue>");
                    } else {
                        tempBuff.append("<end>");
                        System.out.println("Ya ");
                        tempBuff.append("<inclusive>true</inclusive><useValue>" + this.options.getLastValue() + "</useValue>");
                        System.out.println("Yippee");
                        tempBuff.append("</end>");
                        tempBuff.append("</RangePValue>");
                    }
                } else {
                    tempBuff.append("<SimplePValue>");
                    if (useValue.length() == 0) {
                        allEmpty = false;
                        tempBuff.append("<inclusive>true</inclusive><useValue xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:nill=\"true\"/>");
                    } else {
                        allEmpty = false;
                        tempBuff.append("<inclusive>true</inclusive><useValue>" + XMLHelper.encodeXml(useValue) + "</useValue>");
                    }
                    tempBuff.append("</SimplePValue>");
                }
                tempBuff.append("</item>");
            }
            if (!allEmpty) {
                buff.append(tempBuff.toString());
            }
        }
        buff.append("</values>");
        buff.append("</promptValues>");
        buff.insert(0, this.createPromptValues(allEmpty));
        return buff.toString();
    }

    @Override
    public String toString() {
        return super.toString() + PListBox.toStringEntry("autocascade", this.isAutoCascade()) + PListBox.toStringEntry("selectui", this.getSelectUI()) + PListBox.toStringEntry("cascadeon", this.getCascadeOn()) + PListBox.toStringEntry("disable", this.isDisabled());
    }

    @Override
    public boolean isSelected(Object key) {
        Hashtable selections = this.getDefaults();
        if (selections != null) {
            Enumeration keys = selections.keys();
            while (keys.hasMoreElements()) {
                String useValue;
                String displayValue = (String)keys.nextElement();
                if (displayValue.equals(useValue = (String)selections.get(displayValue))) {
                    boolean keyMatch = this.options.containsKey(displayValue);
                    boolean valueMatch = this.options.contains(useValue);
                    if (keyMatch && !valueMatch) {
                        useValue = this.getUseValue(displayValue);
                    } else if (!keyMatch && valueMatch) {
                        displayValue = this.getDisplayValue(useValue);
                    }
                }
                boolean matchingDisplayValue = displayValue.equals(key);
                String selectionUseValue = (String)this.options.get(key);
                boolean matchingUseValue = useValue == null && selectionUseValue == null ? true : (useValue == null ? false : (selectionUseValue == null ? false : useValue.equals(selectionUseValue)));
                if (!matchingDisplayValue || !matchingUseValue) continue;
                return true;
            }
        }
        return false;
    }
}

