/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.prompts;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.prompts.Prompt;
import com.cognos.mobile.xml.XMLHelper;
import java.util.Enumeration;
import java.util.Hashtable;

public class PSearchAndSelect
extends Prompt {
    private final Hashtable options = new Hashtable();
    private boolean caseInsensitive;
    private boolean matchAll;
    private boolean matchAnywhere;
    private String parameter;
    private String cascadeOn;
    private boolean prePopulate;
    private boolean disabled;
    private String searchValue;
    private boolean showOpt = true;

    public final void setShowOpt(boolean b) {
        this.showOpt = b;
    }

    public final boolean isShowOpt() {
        return this.showOpt;
    }

    public final String getSearchValue() {
        return this.searchValue;
    }

    public final void setSearchValue(String searchValue) {
        this.searchValue = searchValue;
    }

    public final String getCascadeOn() {
        return this.cascadeOn;
    }

    public final void setCascadeOn(String cascadeOn) {
        this.cascadeOn = cascadeOn;
    }

    public final boolean isPrePopulate() {
        return this.prePopulate;
    }

    public final void setPrePopulate(boolean prePopulate) {
        this.prePopulate = prePopulate;
    }

    public final boolean isDisabled() {
        return this.disabled;
    }

    public final void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    public final String getTag() {
        return "PSearchAndSelect";
    }

    public void addOption(String displayValue, String useValue) {
        this.options.put(displayValue, useValue);
    }

    public void resetOptions(Hashtable options) {
        this.options.clear();
        if (options == null || options.size() == 0) {
            return;
        }
        Enumeration en = options.keys();
        while (en.hasMoreElements()) {
            String displayValue = (String)en.nextElement();
            String keyValue = (String)options.get(displayValue);
            this.addOption(displayValue, keyValue);
        }
    }

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public final Hashtable getOptions() {
        return this.options;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public boolean isMatchAll() {
        return this.matchAll;
    }

    public void setMatchAll(boolean matchAll) {
        this.matchAll = matchAll;
    }

    public boolean isMatchAnywhere() {
        return this.matchAnywhere;
    }

    public void setMatchAnywhere(boolean matchAnywhere) {
        this.matchAnywhere = matchAnywhere;
    }

    @Override
    public boolean isAcceptable(Object value) throws CMException {
        if (PSearchAndSelect.isNull(value)) {
            if (this.isRequired()) {
                throw new CMException(1404, new String[]{this.getLabel()});
            }
            return true;
        }
        if (value instanceof String[]) {
            if (PSearchAndSelect.isEmpty((String[])value) && this.isRequired()) {
                throw new CMException(1404, new String[]{this.getLabel()});
            }
            return true;
        }
        return value instanceof String && this.options.containsKey(value);
    }

    @Override
    public Object createAcceptableValueFromString(String s) {
        return s;
    }

    public String toSearchPromptAnswers(String value) {
        return this.toSearchPromptAnswers(value, this.isCaseInsensitive(), this.isMatchAll(), this.isMatchAnywhere());
    }

    public String toSearchPromptAnswers() {
        return this.toSearchPromptAnswers(this.getSearchValue(), this.isCaseInsensitive(), this.isMatchAll(), this.isMatchAnywhere());
    }

    public String toSearchPromptAnswers(String value, boolean caseInsensitive, boolean matchAll, boolean matchAnywhere) {
        StringBuffer buff = new StringBuffer();
        buff.append("<searchPValue>");
        buff.append("<value>" + XMLHelper.encodeXml(value) + "</value>");
        buff.append("<parameterName>" + XMLHelper.encodeXml(this.getName()) + "</parameterName>");
        buff.append("<id>" + XMLHelper.encodeXml(this.getId()) + "</id>");
        if (!caseInsensitive) {
            buff.append("<caseInsensitive>false</caseInsensitive>");
        }
        buff.append("<matchAll>" + matchAll + "</matchAll>");
        buff.append("<matchAnywhere>" + matchAnywhere + "</matchAnywhere>");
        buff.append("</searchPValue>");
        return buff.toString();
    }

    @Override
    public final String toPromptAnswers(Object value) {
        StringBuffer buff = new StringBuffer();
        buff.append("<values>");
        boolean allEmpty = true;
        if (PSearchAndSelect.isNull(value)) {
            if (this.isRequired()) {
                return "";
            }
        } else {
            String[] v = (String[])value;
            StringBuffer tempBuff = new StringBuffer();
            for (int i = 0; i < v.length; ++i) {
                String useValue = v[i];
                tempBuff.append("<item>");
                PSearchAndSelect box = this;
                if (box.isRange() && v.length > i + 1 && !v[i].equals(v[i + 1])) {
                    tempBuff.append("<RangePValue>");
                    tempBuff.append("<inclusive>true</inclusive>");
                    tempBuff.append("<start>");
                    String start = v[i++];
                    if (start.length() != 0) {
                        allEmpty = false;
                    }
                    tempBuff.append("<inclusive>true</inclusive><useValue>" + start + "</useValue>");
                    tempBuff.append("</start>");
                    String end = v[i];
                    if (end.toString().length() != 0) {
                        allEmpty = false;
                    }
                    tempBuff.append("<end>");
                    tempBuff.append("<inclusive>true</inclusive><useValue>" + end + "</useValue>");
                    tempBuff.append("</end>");
                    tempBuff.append("</RangePValue>");
                } else {
                    tempBuff.append("<SimplePValue>");
                    if (useValue.length() == 0) {
                        tempBuff.append("<inclusive>true</inclusive><useValue/>");
                    } else {
                        allEmpty = false;
                        tempBuff.append("<inclusive>true</inclusive><useValue>" + XMLHelper.encodeXml(useValue) + "</useValue>");
                    }
                    tempBuff.append("</SimplePValue>");
                }
                tempBuff.append("</item>");
            }
            if (!allEmpty) {
                buff.append(tempBuff.toString());
            }
        }
        buff.append("</values>");
        buff.append("</promptValues>");
        buff.insert(0, this.createPromptValues(allEmpty));
        return buff.toString();
    }

    @Override
    public int type() {
        return 5;
    }

    @Override
    public String toString() {
        return super.toString() + PSearchAndSelect.toStringEntry("cascadeon", this.getCascadeOn()) + PSearchAndSelect.toStringEntry("disable", this.isDisabled()) + PSearchAndSelect.toStringEntry("caseinsensitive", this.isCaseInsensitive()) + PSearchAndSelect.toStringEntry("matchall", this.isMatchAll()) + PSearchAndSelect.toStringEntry("matchanywhere", this.isMatchAnywhere()) + PSearchAndSelect.toStringEntry("prepopulate", this.isPrePopulate()) + PSearchAndSelect.toStringEntry("showopt", this.isShowOpt()) + PSearchAndSelect.toStringEntry("searchvalue", this.getSearchValue()) + PSearchAndSelect.toStringEntry("parameter", this.getParameter());
    }

    public static class Search {
        public final boolean matchAll;
        public final boolean matchAny;
        public final boolean caseInsensitive;
        public final String value;

        public Search(boolean caseInsensitive, boolean matchAll, boolean matchAny, String value) {
            this.caseInsensitive = caseInsensitive;
            this.matchAll = matchAll;
            this.matchAny = matchAny;
            this.value = value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.caseInsensitive ? 1231 : 1237);
            result = 31 * result + (this.matchAll ? 1231 : 1237);
            result = 31 * result + (this.matchAny ? 1231 : 1237);
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Search other = (Search)obj;
            if (this.caseInsensitive != other.caseInsensitive) {
                return false;
            }
            if (this.matchAll != other.matchAll) {
                return false;
            }
            if (this.matchAny != other.matchAny) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }
}

