/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.prompts;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.prompts.Prompt;

public class PTextBox
extends Prompt {
    private boolean numericOnly;
    private boolean multiLine;
    private boolean masked;

    @Override
    public final int type() {
        return 1;
    }

    public final boolean isNumericOnly() {
        return this.numericOnly;
    }

    public final void setNumericOnly(boolean numericOnly) {
        this.numericOnly = numericOnly;
    }

    @Override
    public final String getTag() {
        return "PTextBox";
    }

    public final boolean isMultiLine() {
        return this.multiLine;
    }

    public final void setMultiLine(boolean b) {
        this.multiLine = b;
    }

    public final void setMasked(boolean b) {
        this.masked = b;
    }

    public final boolean isMasked() {
        return this.masked;
    }

    @Override
    public boolean isAcceptable(Object value) throws CMException {
        if (PTextBox.isNull(value)) {
            if (this.isRequired()) {
                throw new CMException(1404, new String[]{this.getLabel()});
            }
            return true;
        }
        if (this.isRange()) {
            if (this.isMultiSelect()) {
                if (!(value instanceof String[][])) {
                    throw new IllegalArgumentException("Must be instance of String[][]");
                }
                String[][] v = (String[][])value;
                if (this.isRequired() && Prompt.isEmpty(v)) {
                    throw new CMException(1404, new String[]{this.getLabel()});
                }
                if (this.isNumericOnly() && !Prompt.isNumeric(v)) {
                    throw new CMException(1401, new String[]{this.getLabel()});
                }
            } else {
                if (!(value instanceof String[])) {
                    throw new IllegalArgumentException("Must be instance of String[]");
                }
                String[] v = (String[])value;
                if (this.isRequired() && Prompt.isEmpty(v)) {
                    throw new CMException(1404, new String[]{this.getLabel()});
                }
                if (!Prompt.isEmpty(v) && this.isNumericOnly() && !Prompt.isNumeric(v)) {
                    throw new CMException(1401, new String[]{this.getLabel()});
                }
            }
        } else if (this.isMultiSelect()) {
            if (!(value instanceof String[])) {
                throw new IllegalArgumentException("Must be instance of String[]");
            }
            String[] v = (String[])value;
            if (this.isRequired() && Prompt.isEmpty(v)) {
                throw new CMException(1404, new String[]{this.getLabel()});
            }
            if (!Prompt.isEmpty(v) && this.isNumericOnly() && !Prompt.isNumeric(v)) {
                throw new CMException(1401, new String[]{this.getLabel()});
            }
        } else {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("Must be instance of String");
            }
            String v = (String)value;
            if (this.isRequired() && Prompt.isEmpty(v)) {
                throw new CMException(1404, new String[]{this.getLabel()});
            }
            if (!Prompt.isEmpty(v) && this.isNumericOnly() && !Prompt.isNumeric(v)) {
                throw new CMException(1401, new String[]{this.getLabel()});
            }
        }
        return true;
    }

    @Override
    public Object createAcceptableValueFromString(String s) {
        if (this.isRange() && this.isMultiSelect()) {
            return new String[][]{{s}};
        }
        if (this.isRange() || this.isMultiSelect()) {
            return new String[]{s};
        }
        return s;
    }

    @Override
    public final String toPromptAnswers(Object value) {
        StringBuffer buff = new StringBuffer();
        buff.append("<values>");
        boolean allEmpty = true;
        if (PTextBox.isNull(value)) {
            if (this.isRequired()) {
                return "";
            }
        } else {
            StringBuffer tempBuff = new StringBuffer();
            if (this.isRange()) {
                if (this.isMultiSelect()) {
                    String[][] vv = (String[][])value;
                    for (int j = 0; j < vv.length; ++j) {
                        String[] v = vv[j];
                        String start = v[0];
                        String end = v[1];
                        if (start.length() == 0 && end.length() == 0) continue;
                        allEmpty = false;
                        if (start.length() > 0 && end.length() > 0) {
                            if (this.isNumericOnly()) {
                                float endF;
                                float startF = Float.parseFloat(start);
                                if (startF > (endF = Float.parseFloat(end))) {
                                    String tmp = start;
                                    start = end;
                                    end = tmp;
                                }
                            } else if (start.compareTo(end) > 0) {
                                String tmp = start;
                                start = end;
                                end = tmp;
                            }
                        }
                        tempBuff.append("<item>" + Prompt.createPRangeValue(start, end, true) + "</item>");
                    }
                } else {
                    String[] v = (String[])value;
                    String start = v[0];
                    String end = v[1];
                    if (start.length() != 0 || end.length() != 0) {
                        allEmpty = false;
                        if (start.length() > 0 && end.length() > 0) {
                            if (this.isNumericOnly()) {
                                float endF;
                                float startF = Float.parseFloat(start);
                                if (startF > (endF = Float.parseFloat(end))) {
                                    String tmp = start;
                                    start = end;
                                    end = tmp;
                                }
                            } else if (start.compareTo(end) > 0) {
                                String tmp = start;
                                start = end;
                                end = tmp;
                            }
                        }
                        tempBuff.append("<item>" + Prompt.createPRangeValue(start, end, true) + "</item>");
                    }
                }
            } else if (this.isMultiSelect()) {
                String[] v = (String[])value;
                for (int i = 0; i < v.length; ++i) {
                    if (v[i].length() > 0) {
                        allEmpty = false;
                    }
                    tempBuff.append("<item>" + Prompt.createPSimpleValue(v[i], true) + "</item>");
                }
            } else {
                String v = (String)value;
                if (v.length() > 0) {
                    allEmpty = false;
                }
                tempBuff.append("<item>" + Prompt.createPSimpleValue(v, true) + "</item>");
            }
            if (!allEmpty) {
                buff.append(tempBuff.toString());
            }
        }
        buff.append("</values>");
        buff.append("</promptValues>");
        buff.insert(0, this.createPromptValues(allEmpty));
        return buff.toString();
    }

    @Override
    public String toString() {
        return super.toString() + PTextBox.toStringEntry("multiline", this.isMultiLine()) + PTextBox.toStringEntry("masked", this.isMasked()) + PTextBox.toStringEntry("numeric", this.isNumericOnly());
    }
}

