/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.prompts;

import com.cognos.mobile.prompts.BasePromptHandler;
import com.cognos.mobile.prompts.PTree;
import com.cognos.mobile.prompts.PromptsContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class PTreeHandler
extends BasePromptHandler {
    public static final String ELEMENT = "PTreePrompt";
    private PTree tree;
    private String optionKey;
    private String optionValue;
    private boolean selectionsAncestry;

    PTreeHandler(PromptsContentHandler conversationHandler) {
        super(conversationHandler);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (localName.equals(ELEMENT)) {
            this.tree = new PTree();
            this.setPrompt(this.tree);
        } else if (localName.equals("treeUI") || localName.equals("canExpand")) {
            this.captureText(true);
        } else if (localName.equals("selectionsAncestry")) {
            this.captureText(true);
            this.selectionsAncestry = true;
        } else if (!this.isCapturingOptions() && (localName.equals("useValue") || localName.equals("displayValue"))) {
            this.captureText(true);
        } else {
            super.startElement(uri, localName, name, attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qname) throws SAXException {
        if (localName.equals(ELEMENT)) {
            this.commitPrompt();
        } else if (localName.equals("canExpand")) {
            this.tree.setCanExpand(this.getText().startsWith("t"));
        } else if (localName.equals("treeUI")) {
            this.tree.setTreeUI(this.getText());
        } else if (localName.equals("selectionsAncestry")) {
            this.selectionsAncestry = false;
        } else if (!this.isCapturingOptions() && localName.equals("useValue")) {
            this.optionKey = this.getText();
        } else if (!this.isCapturingOptions() && localName.equals("displayValue")) {
            this.optionValue = this.getText();
        } else if (!this.isCapturingOptions() && localName.equals("options")) {
            if (this.selectionsAncestry) {
                this.tree.addSelectionsAncestry(this.optionValue, this.optionKey);
            } else {
                this.tree.add(this.optionValue, this.optionKey);
            }
            this.optionKey = null;
            this.optionValue = null;
        } else {
            super.endElement(uri, localName, qname);
        }
    }
}

