/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.prompts;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMLinkedHashtable;
import com.cognos.mobile.xml.XMLHelper;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class Prompt {
    public static final int TEXT = 1;
    public static final int LIST = 2;
    public static final int DATETIME = 3;
    public static final int DATASOURCE = 4;
    public static final int SEARCHANDSELECT = 5;
    public static final int TREE = 6;
    public static final int BUTTON = 7;
    public static final int SIMPLE_P_VALUE = 7;
    private static final String NULL_TOKEN = "<NULL>";
    private static final String NULL_ATTRIBUTE = "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:nill=\"true\" ";
    private String name;
    private String columnName;
    private boolean range;
    private boolean multiSelect;
    private boolean required;
    private boolean autosubmit;
    private boolean noadorn;
    private String label;
    private String id;
    private CMLinkedHashtable selections;
    private Vector rangeSelections;

    public abstract int type();

    public abstract String getTag();

    public void addSelection(String useValue, String displayValue) {
        if (this.selections == null) {
            this.selections = new CMLinkedHashtable();
        }
        this.selections.put(displayValue, useValue);
    }

    public void addRangeSelection(String startUseValue, String startDisplayValue, String endUseValue, String endDisplayValue) {
        if (this.rangeSelections == null) {
            this.rangeSelections = new Vector();
        }
        Range r = new Range(startUseValue, startDisplayValue, endUseValue, endDisplayValue);
        this.rangeSelections.addElement(r);
    }

    public Range getDefaultRange() {
        if (this.rangeSelections == null || this.rangeSelections.size() == 0) {
            return null;
        }
        return (Range)this.rangeSelections.elementAt(0);
    }

    public Range[] getDefaultRanges() {
        if (this.rangeSelections == null || this.rangeSelections.size() == 0) {
            return new Range[0];
        }
        Range[] r = new Range[this.rangeSelections.size()];
        Enumeration en = this.rangeSelections.elements();
        int i = 0;
        while (en.hasMoreElements()) {
            r[i++] = (Range)en.nextElement();
        }
        return r;
    }

    public final String getDefaultValue() {
        if (this.selections == null || this.selections.size() == 0) {
            return "";
        }
        Enumeration en = this.selections.elements();
        return (String)en.nextElement();
    }

    public final String[] getDefaultsKeys() {
        if (this.selections == null || this.selections.size() == 0) {
            return new String[0];
        }
        String[] result = new String[this.selections.size()];
        int i = 0;
        Enumeration en = this.selections.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String value = (String)this.selections.get(key);
            result[i++] = value;
        }
        return result;
    }

    public final String[] getDefaultsValues() {
        if (this.selections == null || this.selections.size() == 0) {
            return new String[0];
        }
        String[] result = new String[this.selections.size()];
        int i = 0;
        Enumeration en = this.selections.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String value = (String)this.selections.get(key);
            result[i++] = value;
        }
        return result;
    }

    public final Hashtable getDefaults() {
        return this.selections;
    }

    public final String getColumnName() {
        return this.columnName;
    }

    public final void setColumnName(String name) {
        this.columnName = name;
    }

    public final boolean isNoAdorn() {
        return this.noadorn;
    }

    public final void setNoAdorn(boolean b) {
        this.noadorn = b;
    }

    public final void setId(String id) {
        this.id = id;
    }

    public final String getId() {
        return this.id;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final boolean isAuto() {
        return this.autosubmit;
    }

    public final void setAuto(boolean b) {
        this.autosubmit = b;
    }

    public String createPromptValues(boolean empty) {
        StringBuffer buff = new StringBuffer();
        buff.append("<promptValues");
        if (this.isRequired()) {
            buff.append(" required=\"true\"");
        } else {
            buff.append(" required=\"false\"");
        }
        if (this.isAuto()) {
            buff.append(" autosubmit=\"true\"");
        } else {
            buff.append(" autosubmit=\"false\"");
        }
        if (this.isRange()) {
            buff.append(" range=\"true\"");
        } else {
            buff.append(" range=\"false\"");
        }
        if (this.isMultiSelect()) {
            buff.append(" multiselect=\"true\"");
        } else {
            buff.append(" multiselect=\"false\"");
        }
        if (empty) {
            buff.append(" empty=\"true\"");
        } else {
            buff.append(" empty=\"false\"");
        }
        buff.append(" type=\"" + this.type() + "\"");
        buff.append(">");
        buff.append("<name>" + XMLHelper.encodeXml(this.getName()) + "</name>");
        return buff.toString();
    }

    public final String getLabel() {
        if (this.label == null) {
            String text = "";
            if (this.getColumnName() != null && this.getColumnName() != "") {
                text = this.getColumnName();
            } else {
                String string = text = this.getName() == null ? "" : this.getName();
            }
            if (this.isRequired()) {
                text = "* " + text;
            }
            this.label = text;
        }
        return this.label;
    }

    public final boolean isMultiSelect() {
        return this.multiSelect;
    }

    public final void setMultiSelect(boolean multiSelect) {
        this.multiSelect = multiSelect;
    }

    public final boolean isRequired() {
        return this.required;
    }

    public final void setRequired(boolean required) {
        this.required = required;
    }

    public final void setRange(boolean range) {
        this.range = range;
    }

    public final boolean isRange() {
        return this.range;
    }

    public abstract String toPromptAnswers(Object var1);

    public abstract boolean isAcceptable(Object var1) throws CMException;

    public abstract Object createAcceptableValueFromString(String var1);

    public static boolean isNumeric(String s) {
        try {
            Float.valueOf(s);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String[] s) {
        for (int i = 0; i < s.length; ++i) {
            if (Prompt.isNumeric(s[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String[][] s) {
        for (int i = 0; i < s.length; ++i) {
            if (Prompt.isNumeric(s[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isEmpty(String[] s) {
        for (int i = 0; i < s.length; ++i) {
            if (Prompt.isEmpty(s[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(String[][] s) {
        for (int i = 0; i < s.length; ++i) {
            if (Prompt.isEmpty(s[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean _isNull(Object s) {
        return s == null;
    }

    public static boolean isNull(Object s) {
        if (s instanceof Object[]) {
            return Prompt.isNull((Object[])s);
        }
        if (s instanceof Object[][]) {
            return Prompt.isNull((Object[])((Object[][])s));
        }
        return Prompt._isNull(s);
    }

    public static boolean isNull(Object[] s) {
        for (int i = 0; i < s.length; ++i) {
            if (Prompt._isNull(s[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isNull(String[][] s) {
        for (int i = 0; i < s.length; ++i) {
            if (Prompt._isNull(s[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isRange(String[] s) {
        return s.length == 2;
    }

    public static boolean isRange(String[][] s) {
        for (int j = 0; j < s.length; ++j) {
            if (Prompt.isRange(s[j])) continue;
            return false;
        }
        return true;
    }

    public static boolean isNullToken(String s) {
        return s != null && s.equals(NULL_TOKEN);
    }

    public static String createPRangeValue(String start, String end, boolean inclusive) {
        return Prompt.createPRangeValue(start, end, null, null, inclusive);
    }

    public static String createPRangeValue(String startUse, String endUse, String startDisplay, String endDisplay, boolean inclusive) {
        StringBuffer tempBuff = new StringBuffer();
        String strInclusive = "" + inclusive;
        strInclusive = strInclusive.toLowerCase();
        tempBuff.append("<RangePValue><inclusive>" + strInclusive + "</inclusive>");
        if (startUse != null && startUse.trim().length() != 0) {
            tempBuff.append("<start><inclusive>" + strInclusive + "</inclusive>");
            if (Prompt.isNullToken(startUse)) {
                tempBuff.append("<useValue xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:nill=\"true\" ></useValue>");
            } else {
                tempBuff.append("<useValue>" + startUse + "</useValue>");
            }
            if (startDisplay != null && startDisplay.trim().length() != 0) {
                if (Prompt.isNullToken(startDisplay)) {
                    tempBuff.append("<displayValue xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:nill=\"true\" ></displayValue>");
                } else {
                    tempBuff.append("<displayValue>" + startDisplay + "</displayValue>");
                }
            }
            tempBuff.append("</start>");
        }
        if (endUse != null && endUse.trim().length() != 0) {
            tempBuff.append("<end><inclusive>" + strInclusive + "</inclusive>");
            if (Prompt.isNullToken(endUse)) {
                tempBuff.append("<useValue xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:nill=\"true\" ></useValue>");
            } else {
                tempBuff.append("<useValue>" + endUse + "</useValue>");
            }
            if (endDisplay != null && endDisplay.trim().length() != 0) {
                if (Prompt.isNullToken(endDisplay)) {
                    tempBuff.append("<displayValue xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:nill=\"true\" ></displayValue>");
                } else {
                    tempBuff.append("<displayValue>" + endDisplay + "</displayValue>");
                }
            }
            tempBuff.append("</end>");
        }
        tempBuff.append("</RangePValue>");
        return tempBuff.toString();
    }

    public static String createPSimpleValue(String value, boolean inclusive) {
        return Prompt.createPSimpleValue(value, null, inclusive);
    }

    public static String createPSimpleValue(String useValue, String displayValue, boolean inclusive) {
        StringBuffer tempBuff = new StringBuffer();
        String strInclusive = "" + inclusive;
        strInclusive = strInclusive.toLowerCase();
        tempBuff.append("<SimplePValue>");
        if (useValue.length() > 0) {
            if (Prompt.isNullToken(useValue)) {
                tempBuff.append("<inclusive>" + strInclusive + "</inclusive><useValue " + NULL_ATTRIBUTE + "></useValue>");
            } else {
                tempBuff.append("<inclusive>" + strInclusive + "</inclusive><useValue>" + XMLHelper.encodeXml(useValue) + "</useValue>");
            }
        } else {
            tempBuff.append("<inclusive>" + strInclusive + "</inclusive><useValue/>");
        }
        if (displayValue != null && displayValue.length() > 0) {
            if (Prompt.isNullToken(displayValue)) {
                tempBuff.append("<displayValue xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:nill=\"true\" ></displayValue>");
            } else {
                tempBuff.append("<displayValue>" + XMLHelper.encodeXml(displayValue) + "</displayValue>");
            }
        }
        tempBuff.append("</SimplePValue>");
        return tempBuff.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnName == null ? 0 : this.columnName.hashCode());
        result = 31 * result + (this.multiSelect ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Prompt other = (Prompt)obj;
        if (this.type() != other.type()) {
            return false;
        }
        if (this.columnName == null ? other.columnName != null : !this.columnName.equals(other.columnName)) {
            return false;
        }
        if (this.multiSelect != other.multiSelect) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public static String toStringEntry(String key, Object value) {
        if (value != null) {
            value = XMLHelper.encodeXml("" + value);
            return key + "=\"" + value + "\" ";
        }
        return "";
    }

    public static String toStringEntry(String key, boolean value) {
        return key + "=\"" + value + "\" ";
    }

    public static String toStringEntry(String key, int value) {
        return key + "=\"" + value + "\" ";
    }

    public String toString() {
        return Prompt.toStringEntry("id", this.getId()) + Prompt.toStringEntry("auto", this.isAuto()) + Prompt.toStringEntry("req", this.isRequired()) + Prompt.toStringEntry("multiselect", this.isMultiSelect()) + Prompt.toStringEntry("range", this.isRange()) + Prompt.toStringEntry("label", this.getLabel()) + Prompt.toStringEntry("name", this.getName() == null ? null : "p_" + this.getName()) + Prompt.toStringEntry("type", this.getTag()) + Prompt.toStringEntry("noadorn", this.isNoAdorn()) + Prompt.toStringEntry("columnname", this.getColumnName());
    }

    public boolean isSelected(Object key) {
        return this.selections != null && this.selections.containsKey(key);
    }

    public boolean isValueSelected(Object value) {
        return this.selections != null && this.selections.containsValue(value);
    }

    public static class Range {
        private String startUseValue;
        private String startDisplayValue;
        private String endUseValue;
        private String endDisplayValue;

        public Range(String startUseValue, String startDisplayValue, String endUseValue, String endDisplayValue) {
            this.startUseValue = startUseValue;
            this.startDisplayValue = startDisplayValue;
            this.endUseValue = endUseValue;
            this.endDisplayValue = endDisplayValue;
        }

        public void set(String startUseValue, String startDisplayValue, String endUseValue, String endDisplayValue) {
            this.startUseValue = startUseValue;
            this.startDisplayValue = startDisplayValue;
            this.endUseValue = endUseValue;
            this.endDisplayValue = endDisplayValue;
        }

        public String getStartUseValue() {
            return this.startUseValue;
        }

        public String getStartDisplayValue() {
            return this.startDisplayValue;
        }

        public String getEndUseValue() {
            return this.endUseValue;
        }

        public String getEndDisplayValue() {
            return this.endDisplayValue;
        }
    }
}

