/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.prompts;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.prompts.Prompt;
import com.cognos.mobile.prompts.PromptControl;
import com.cognos.mobile.prompts.Prompts;
import com.cognos.mobile.vm.VM;
import java.util.Enumeration;
import java.util.Vector;

public final class PromptsProcessor {
    private static final Class CLASS = PromptsProcessor.class;
    private final Prompts prompts;
    private final Vector controls = new Vector();
    private final Prompts.IValuableFactory valuableFactory;
    private CMException[] results;

    public PromptsProcessor(Prompts prompts, Prompts.IValuableFactory valuableFactory) {
        this.prompts = prompts;
        this.valuableFactory = valuableFactory;
        Prompt[] items = prompts.listPromptItems();
        for (int i = 0; i < items.length; ++i) {
            this.add(items[i]);
        }
    }

    public int processPrompts() {
        this.results = null;
        Vector<CMException> validationResults = new Vector<CMException>();
        Enumeration it = this.controls.elements();
        while (it.hasMoreElements()) {
            PromptControl control = (PromptControl)it.nextElement();
            VM.log(CLASS, 0, "control: " + control);
            try {
                VM.log(CLASS, 0, "control prompt: " + control.getPrompt());
                VM.log(CLASS, 0, "control name: " + control.getPrompt().getName());
                VM.log(CLASS, 0, "control value: " + control.value());
                if (!control.getPrompt().isAcceptable(control.value())) continue;
                this.prompts.setValue(control.getPrompt().getName(), control.value());
            }
            catch (CMException cme) {
                if (cme.getErrorCode() < 1400) continue;
                cme.setAttachedArgument(control);
                validationResults.addElement(cme);
            }
        }
        if (validationResults.size() > 0) {
            this.reportExceptions(validationResults);
            this.results = new CMException[validationResults.size()];
            Enumeration en = validationResults.elements();
            int i = 0;
            while (en.hasMoreElements()) {
                this.results[i++] = (CMException)en.nextElement();
            }
            return 2;
        }
        return 0;
    }

    public CMException[] getValidationResults() {
        if (this.results == null) {
            return new CMException[0];
        }
        return this.results;
    }

    private void reportExceptions(Vector e) {
    }

    private void add(Prompt item) {
        Prompts.IValuable control = this.valuableFactory.create(item);
        if (control != null) {
            this.controls.addElement(new PromptControl(item, control));
        }
    }
}

