/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.prompts;

import java.util.Vector;

public class TreePromptNode {
    private final TreePromptNode parent;
    private final Vector children = new Vector();
    private final String displayValue;
    private final String useValue;
    private boolean leaf;

    public TreePromptNode(String displayValue, String useValue) {
        this(null, displayValue, useValue);
    }

    public TreePromptNode(TreePromptNode parent, String displayValue, String useValue) {
        this.parent = parent;
        this.displayValue = displayValue;
        this.useValue = useValue;
    }

    public String getDisplayValue() {
        return this.displayValue;
    }

    public String getUseValue() {
        return this.useValue;
    }

    public final TreePromptNode getParent() {
        return this.parent;
    }

    public final Vector getSiblings() {
        if (this.isRoot()) {
            return new Vector();
        }
        Vector kids = this.getParent().getChildren();
        Vector v = new Vector();
        for (int i = 0; i < kids.size(); ++i) {
            Object o = kids.elementAt(i);
            if (o.equals(this)) continue;
            v.addElement(o);
        }
        return v;
    }

    public final boolean isRoot() {
        return this.parent == null;
    }

    public final boolean hasChildren() {
        return this.children.size() != 0;
    }

    public final void setLeaf() {
        this.leaf = true;
    }

    public final boolean isLeaf() {
        return this.leaf;
    }

    public void add(String useValue, String keyValue) {
        this.children.addElement(new TreePromptNode(this, keyValue, useValue));
    }

    public Vector getChildren() {
        return this.children;
    }

    public String toString() {
        return this.getDisplayValue();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.useValue == null ? 0 : this.useValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TreePromptNode other = (TreePromptNode)obj;
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        return !(this.useValue == null ? other.useValue != null : !this.useValue.equals(other.useValue));
    }
}

