/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.prompts;

import com.cognos.mobile.prompts.TreePromptNode;
import java.util.Vector;

public class TreePromptNodeCookie {
    private final String path;
    private final TreePromptNode item;
    private Exception exception;
    private boolean checked = false;
    private boolean infered = false;
    private boolean preSelected = false;
    private final ITreeNodeHost host;

    public TreePromptNodeCookie(ITreeNodeHost host, TreePromptNode item, String path, boolean checked) {
        this.item = item;
        this.path = path;
        this.host = host;
        this.checked = checked;
    }

    public final String getPath() {
        return this.path;
    }

    public TreePromptNode getItem() {
        return this.item;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public boolean isInfered() {
        return this.infered;
    }

    public boolean isPreSelected() {
        return this.preSelected;
    }

    public boolean flipCheck() {
        if (!this.checked) {
            this.check();
        } else {
            this.uncheck();
        }
        return this.checked;
    }

    private void infer() {
        if (!this.checked) {
            this.infered = true;
            this.host.nodeChanged(this.item);
        }
        if (!this.item.isRoot()) {
            this.host.getNodeCookie(this.item.getParent()).infer();
        }
    }

    public void check() {
        this.checked = true;
        this.infered = false;
        if (this.item != null) {
            this.host.nodeChanged(this.item);
            if (!this.item.isRoot()) {
                this.host.getNodeCookie(this.item.getParent()).infer();
            }
        }
    }

    public void setPreSelected(boolean flag) {
        this.preSelected = flag;
    }

    private boolean hasChecked(Vector v) {
        for (int i = 0; i < v.size(); ++i) {
            TreePromptNodeCookie c = this.host.getNodeCookie((TreePromptNode)v.elementAt(i));
            if (!c.isChecked()) continue;
            return true;
        }
        return false;
    }

    private boolean hasInfered(Vector v) {
        for (int i = 0; i < v.size(); ++i) {
            TreePromptNodeCookie c = this.host.getNodeCookie((TreePromptNode)v.elementAt(i));
            if (!c.isInfered()) continue;
            return true;
        }
        return false;
    }

    public boolean isPlaceholder() {
        return this.path == null;
    }

    private boolean hasCheckedChildren() {
        if (this.item == null) {
            return false;
        }
        return this.hasChecked(this.item.getChildren());
    }

    private boolean hasInferedChildren() {
        if (this.item == null) {
            return false;
        }
        return this.hasInfered(this.item.getChildren());
    }

    public String toString() {
        return this.item.getDisplayValue();
    }

    public void uncheck() {
        TreePromptNodeCookie c;
        if (!this.checked && this.infered) {
            if (!this.hasCheckedChildren() && !this.hasInferedChildren()) {
                this.infered = false;
            }
        } else {
            this.checked = false;
            if (this.hasCheckedChildren() || this.hasInferedChildren()) {
                this.infered = true;
            }
        }
        this.host.nodeChanged(this.item);
        if (this.item != null && !this.item.isRoot() && !(c = this.host.getNodeCookie(this.item.getParent())).isChecked()) {
            c.uncheck();
        }
    }

    public static interface ITreeNodeHost {
        public TreePromptNodeCookie getNodeCookie(TreePromptNode var1);

        public void nodeChanged(TreePromptNode var1);
    }
}

