/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.prompts;

import com.cognos.mobile.prompts.BaseHandler;
import com.cognos.mobile.prompts.TreePromptNode;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TreePromptNodeHandler
extends BaseHandler {
    public static final String ELEMENT = "treePromptNode";
    private TreePromptNode treeNode;
    private String optionKey;
    private String optionValue;
    private int namespaceNameLength = -1;

    public TreePromptNodeHandler(TreePromptNode tree) {
        this.treeNode = tree;
    }

    private String stripNamespace(String name) {
        int i = name.indexOf(58);
        if (i == -1) {
            return name;
        }
        if (this.namespaceNameLength == -1) {
            this.namespaceNameLength = i + 1;
        }
        return name.substring(this.namespaceNameLength);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (localName == null || localName.length() == 0) {
            localName = this.stripNamespace(name);
        }
        System.out.println("Localname: " + localName);
        System.out.println("Name: " + name);
        if (localName.equals(ELEMENT)) {
            this.captureText(false);
        } else if (localName.equals("useValue") || localName.equals("displayValue")) {
            this.captureText(true);
        } else {
            this.captureText(false);
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (localName == null || localName.length() == 0) {
            localName = this.stripNamespace(name);
        }
        if (localName.equals(ELEMENT)) {
            if (!this.treeNode.hasChildren()) {
                this.treeNode.setLeaf();
            }
        } else if (localName.equals("useValue")) {
            this.optionKey = this.getText();
        } else if (localName.equals("displayValue")) {
            this.optionValue = this.getText();
        } else if (localName.equals("options")) {
            System.out.println("adding: " + this.optionKey + " : " + this.optionValue);
            this.treeNode.add(this.optionKey, this.optionValue);
            this.optionKey = null;
            this.optionValue = null;
        }
    }
}

