/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.request;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.ICredentialPrompter;
import com.cognos.mobile.request.IRecoverableResponseHandler;
import com.cognos.mobile.request.IServerRequest;
import com.cognos.mobile.request.IServerResponse;
import com.cognos.mobile.task.ITaskMonitor;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMOptions;

public class BadServerResponseHandler
implements IRecoverableResponseHandler {
    private static final Class CLASS = BadServerResponseHandler.class;
    private VMOptions options;
    private ICredentialPrompter credentialPrompter;

    public BadServerResponseHandler(VMOptions options, ICredentialPrompter credentialPrompter) {
        this.options = options;
        this.credentialPrompter = credentialPrompter;
    }

    @Override
    public boolean canHandle(IServerResponse response) throws CMException {
        if (this.credentialPrompter == null) {
            return false;
        }
        switch (response.getResponseCode()) {
            case 400: 
            case 404: 
            case 405: 
            case 410: 
            case 502: {
                return true;
            }
        }
        return false;
    }

    @Override
    public IServerRequest handle(IServerRequest originalRequest, IServerRequest request, IServerResponse response, ITaskMonitor taskMonitor) throws CMException {
        CMException lastEx;
        VM.log(CLASS, 1, "BadServerResponseHandler.handle: " + originalRequest.toString());
        VM.log(CLASS, 1, "BadServerResponseHandler.handle responseCode: " + response.getResponseCode());
        if (response != null) {
            VM.log(CLASS, 2, "received HTTP response: " + response.getResponseCode());
            lastEx = new CMException(1156, new String[]{Integer.toString(response.getResponseCode())});
        } else {
            lastEx = new CMException(1156, new String[]{"404"});
        }
        while (true) {
            taskMonitor.throwIfCancelled();
            VM.log(CLASS, 1, "BadServerResponseHandler.handle: calling promptServerUrl");
            String newServerUrl = this.credentialPrompter.promptServerUrl(this.options.getServerUrl(), lastEx);
            try {
                this.options.setServerUrl(newServerUrl, true);
                this.options.save();
                IServerRequest newRequest = request.copy(this.options.getEffectiveServerUri(), 3);
                return newRequest;
            }
            catch (CMException ex) {
                lastEx = ex;
                continue;
            }
            break;
        }
    }
}

