/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.request;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMExceptionMissingCredentials;
import com.cognos.mobile.common.CMIDs;
import com.cognos.mobile.common.CMUrlConstants;
import com.cognos.mobile.common.CMUrlHelper;
import com.cognos.mobile.common.ICredentialPrompter;
import com.cognos.mobile.common.IResourceManager;
import com.cognos.mobile.html.HTFormElement;
import com.cognos.mobile.request.IRecoverableResponseHandler;
import com.cognos.mobile.request.IServerRequest;
import com.cognos.mobile.request.IServerResponse;
import com.cognos.mobile.task.CancellationException;
import com.cognos.mobile.task.ITaskMonitor;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMOptions;
import java.util.Hashtable;
import java.util.Vector;

public class BasicAuthenticationFaultHandler
implements IRecoverableResponseHandler {
    private static final Class CLASS = BasicAuthenticationFaultHandler.class;
    private IResourceManager resourceManager;
    private VMOptions options;
    private ICredentialPrompter credentialPrompter;

    public BasicAuthenticationFaultHandler(IResourceManager resourceManager, VMOptions options, ICredentialPrompter credentialPrompter) {
        this.resourceManager = resourceManager;
        this.options = options;
        this.credentialPrompter = credentialPrompter;
    }

    @Override
    public boolean canHandle(IServerResponse response) throws CMException {
        String authenticateHeader;
        return response.getResponseCode() == 401 && (authenticateHeader = response.getHeader(CMUrlConstants.HEADER_AUTHENTICATE)) != null && authenticateHeader.toLowerCase().startsWith("basic");
    }

    @Override
    public IServerRequest handle(IServerRequest originalRequest, IServerRequest request, IServerResponse response, ITaskMonitor taskMonitor) throws CMException {
        String authenticateHeader = response.getHeader(CMUrlConstants.HEADER_AUTHENTICATE);
        Hashtable<String, String> credentials = this.options.getCredentials("HTTP-BASIC", false);
        if (credentials == null) {
            credentials = new Hashtable<String, String>();
            VM.log(CLASS, 0, "no cached basic auth credentials");
        } else {
            VM.log(CLASS, 0, "retrieved cached basic auth credentials creds are " + credentials.get("d") + ", " + credentials.get("u"));
        }
        VM.log(CLASS, 0, "prompting");
        Object[] formElements = null;
        CMUrlHelper.AuthenticateHeader header = CMUrlHelper.parseAuthenticateHeader(authenticateHeader);
        Vector<HTFormElement> missingCredentials = null;
        if (this.credentialPrompter == null) {
            missingCredentials = new Vector<HTFormElement>();
        }
        Vector<HTFormElement> formElementsV = new Vector<HTFormElement>();
        if (header.realm != null && header.realm.length() > 0) {
            formElementsV.addElement(new HTFormElement(0, this.resourceManager.formatString(CMIDs.LOGON_ENTER_NETWORK_CREDENTIALS, header.realm), null));
        } else {
            formElementsV.addElement(new HTFormElement(0, this.resourceManager.loadString(CMIDs.LOGON_ENTER_NETWORK_CREDENTIALS_2), null));
        }
        if (response.getAuthenticationDomain() != null) {
            formElementsV.addElement(new HTFormElement(0, this.resourceManager.loadString(CMIDs.LOGON_DOMAIN), null));
            String domain = (String)credentials.get("d");
            if (domain == null || domain.length() == 0) {
                domain = response.getAuthenticationDomain();
            }
            HTFormElement domainElt = new HTFormElement(1, "d", domain);
            formElementsV.addElement(domainElt);
            if (missingCredentials != null && (domain == null || domain.length() == 0)) {
                missingCredentials.addElement(domainElt);
            }
        }
        formElementsV.addElement(new HTFormElement(0, this.resourceManager.loadString(CMIDs.LOGON_USERNAME), null));
        String username = (String)credentials.get("u");
        HTFormElement usernameElt = new HTFormElement(1, "u", username);
        formElementsV.addElement(usernameElt);
        if (missingCredentials != null && (username == null || username.length() == 0)) {
            missingCredentials.addElement(usernameElt);
        }
        formElementsV.addElement(new HTFormElement(0, this.resourceManager.loadString(CMIDs.LOGON_PASSWORD), null));
        String password = (String)credentials.get("p");
        HTFormElement passwordElt = new HTFormElement(2, "p", password);
        formElementsV.addElement(passwordElt);
        if (missingCredentials != null && (password == null || password.length() == 0)) {
            missingCredentials.addElement(passwordElt);
        }
        if (missingCredentials != null && !missingCredentials.isEmpty()) {
            Object[] missingCredentialsA = new HTFormElement[missingCredentials.size()];
            missingCredentials.copyInto(missingCredentialsA);
            CMExceptionMissingCredentials e = new CMExceptionMissingCredentials((HTFormElement[])missingCredentialsA);
            VM.log(CLASS, 0, e.toString());
            throw e;
        }
        formElements = new HTFormElement[formElementsV.size()];
        formElementsV.copyInto(formElements);
        int result = 0;
        if (this.credentialPrompter != null) {
            taskMonitor.throwIfCancelled();
            result = this.credentialPrompter.promptCredentials(this.resourceManager.loadString(CMIDs.AUTHENTICATE_TITLE), (HTFormElement[])formElements, request.isAnonymousEnabled() ? 1 : 0);
        }
        switch (result) {
            case 0: {
                break;
            }
            default: {
                VM.log(CLASS, 1, "BasicAuthenticationFaultHandler.handle: throwing CancellationException");
                throw new CancellationException();
            }
        }
        credentials.clear();
        for (int idx = 0; idx < formElements.length; ++idx) {
            switch (((HTFormElement)formElements[idx]).getType()) {
                case 1: 
                case 2: {
                    String value = ((HTFormElement)formElements[idx]).getValue();
                    credentials.put(((HTFormElement)formElements[idx]).getName(), value == null ? "" : value);
                }
            }
        }
        this.options.setCredentials("HTTP-BASIC", credentials);
        this.options.save();
        VM.log(CLASS, 0, "prompted and saved");
        return request.copy();
    }
}

