/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.request;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.ICMXMLParserFactory;
import com.cognos.mobile.common.MobileServiceProxy;
import com.cognos.mobile.request.IRecoverableResponseHandler;
import com.cognos.mobile.request.IServerRequest;
import com.cognos.mobile.request.IServerResponse;
import com.cognos.mobile.task.ITaskMonitor;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.xml.IXMLParser;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ChunkedRequestHandler
implements IRecoverableResponseHandler {
    private static final String SIGNATURE = "<chunkedRequest id=";
    private final ICMXMLParserFactory xmlPFact;
    private int id;
    private int length;

    public ChunkedRequestHandler(MobileServiceProxy service, ICMXMLParserFactory xmlPFact) {
        this.xmlPFact = xmlPFact;
    }

    @Override
    public boolean canHandle(IServerResponse response) throws CMException {
        if (response.getResponseCode() != 200) {
            return false;
        }
        return response.responseBodyContains(SIGNATURE);
    }

    @Override
    public IServerRequest handle(IServerRequest originalRequest, IServerRequest request, IServerResponse response, ITaskMonitor taskMonitor) throws CMException {
        InputStream in = response.getInputStream();
        IXMLParser p = this.xmlPFact.create();
        MyHandler h = new MyHandler();
        try {
            p.parse(in, h);
            return null;
        }
        catch (IOException se) {
            VM.log(this.getClass(), 3, se);
            throw new CMException(1009, (Throwable)se);
        }
        catch (SAXException se) {
            Exception e = se.getException();
            if (e == null) {
                VM.log(this.getClass(), 3, se);
                throw new CMException(1009, (Throwable)se);
            }
            if (e instanceof CMException) {
                VM.log(this.getClass(), 3, "SAX exception '" + se.toString() + "'", e);
                throw (CMException)e;
            }
            VM.log(this.getClass(), 3, "SAX exception '" + se.toString() + "'", e);
            throw new CMException(1009, se.toString(), (Throwable)e);
        }
    }

    public int getChunkId() {
        return this.id;
    }

    public int getLength() {
        return this.length;
    }

    private class MyHandler
    extends DefaultHandler {
        private MyHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qname, Attributes atts) throws SAXException {
            if (qname.equalsIgnoreCase("chunkedRequest")) {
                ChunkedRequestHandler.this.id = Integer.parseInt(atts.getValue("id"));
                ChunkedRequestHandler.this.length = Integer.parseInt(atts.getValue("length"));
            }
        }
    }
}

