/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.request;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMUrlConstants;
import com.cognos.mobile.request.IRecoverableResponseHandler;
import com.cognos.mobile.request.IServerRequest;
import com.cognos.mobile.request.IServerResponse;
import com.cognos.mobile.task.ITaskMonitor;
import com.cognos.mobile.vm.VM;
import java.io.IOException;
import java.io.InputStream;

public class DBResponseHandler
implements IRecoverableResponseHandler {
    private static final Class CLASS = DBResponseHandler.class;
    private int totalLength = -1;
    private byte[] bytes = null;
    private int offset = 0;
    private int bytesReceived = 0;

    public DBResponseHandler() {
    }

    public DBResponseHandler(byte[] bytes, int offset) {
        this.bytes = bytes;
        this.offset = offset;
    }

    @Override
    public boolean canHandle(IServerResponse response) throws CMException {
        return response.getResponseCode() == 200 && response.getContentType().equals(CMUrlConstants.CONTENT_TYPE_MOB_DB);
    }

    @Override
    public IServerRequest handle(IServerRequest originalRequest, IServerRequest request, IServerResponse response, ITaskMonitor taskMonitor) throws CMException {
        int length;
        String header = response.getHeader(CMUrlConstants.HEADER_DB_LENGTH);
        if (header != null) {
            try {
                this.totalLength = Integer.parseInt(header);
                if (this.bytes != null && this.bytes.length != this.totalLength) {
                    throw new CMException(2019, "internal error while downloading render; total length is " + this.totalLength + " bytes but provided buffer is " + this.bytes.length + " bytes");
                }
            }
            catch (NumberFormatException nfe) {
                VM.log(CLASS, 2, "invalid length header '" + header + "'");
            }
        }
        if ((header = response.getHeader(CMUrlConstants.HEADER_OFFSET)) != null) {
            try {
                int receivedOffset = Integer.parseInt(header);
                if (receivedOffset != this.offset) {
                    throw new CMException(2019, "couldn't download render; requested offset " + this.offset + " but received offset " + receivedOffset);
                }
            }
            catch (NumberFormatException nfe) {
                VM.log(CLASS, 2, "invalid offset header '" + header + "'");
            }
        }
        if (this.offset + (length = response.getContentLength()) > this.totalLength) {
            throw new CMException(2019, "couldn't download render; too many bytes returned (offset " + this.offset + ", length " + length + ", total length " + this.totalLength);
        }
        if (this.bytes == null) {
            this.bytes = new byte[length];
        }
        InputStream inputStream = response.getInputStream();
        try {
            int read;
            int i = 0;
            while (i < length && (read = inputStream.read(this.bytes, this.offset, length - i)) > 0) {
                this.offset += read;
                i += read;
                this.bytesReceived += read;
            }
        }
        catch (IOException ioe) {
            throw new CMException(2003, (Throwable)ioe);
        }
        return null;
    }

    public int getTotalLength() {
        return this.totalLength;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getBytesReceived() {
        return this.bytesReceived;
    }
}

