/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.request;

import com.cognos.mobile.client.Controller;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMExceptionMissingCredentials;
import com.cognos.mobile.common.CMUrlHelper;
import com.cognos.mobile.common.ICredentialPrompter;
import com.cognos.mobile.html.HTFormElement;
import com.cognos.mobile.html.HTFormHandler;
import com.cognos.mobile.request.IRecoverableResponseHandler;
import com.cognos.mobile.request.IServerRequest;
import com.cognos.mobile.request.IServerRequestFactory;
import com.cognos.mobile.request.IServerResponse;
import com.cognos.mobile.request.URI;
import com.cognos.mobile.tagsoup.Parser;
import com.cognos.mobile.task.CancellationException;
import com.cognos.mobile.task.ITaskMonitor;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMOptions;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.SAXException;

public class HtmlResponseHandler
implements IRecoverableResponseHandler {
    private static final Class CLASS = HtmlResponseHandler.class;
    private final VMOptions options;
    private final ICredentialPrompter credentialPrompter;
    private Controller controller;

    public HtmlResponseHandler(VMOptions options, ICredentialPrompter credentialPrompter) {
        this.options = options;
        this.credentialPrompter = credentialPrompter;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    @Override
    public boolean canHandle(IServerResponse response) throws CMException {
        return response.getResponseCode() == 200 && response.getContentType().toLowerCase().startsWith("text/html");
    }

    @Override
    public IServerRequest handle(IServerRequest originalRequest, IServerRequest request, IServerResponse response, ITaskMonitor taskMonitor) throws CMException {
        String message;
        IServerRequest newRequest;
        HTFormHandler htmlFormHandler = new HTFormHandler();
        Parser htmlParser = new Parser();
        try {
            htmlFormHandler.doParse(htmlParser, response.getInputStream());
        }
        catch (SAXException ex) {
            VM.log(CLASS, 3, ex);
            throw new CMException(1106, (Throwable)ex);
        }
        catch (IOException ex) {
            VM.log(CLASS, 3, ex);
            throw new CMException(1106, (Throwable)ex);
        }
        String refreshUrl = htmlFormHandler.getRefreshUrl();
        if (refreshUrl != null) {
            IServerRequest newRequest2;
            if (refreshUrl.indexOf("b_action=xts.run") > -1) {
                if (request.getArgument("CAMUsername") != null && request.getArgument("CAMPassword") != null) {
                    return null;
                }
                int pos = refreshUrl.indexOf(63);
                URI newUri = this.options.effectiveServerUrlFollowRedirect(refreshUrl.substring(0, pos));
                newRequest2 = originalRequest.copy(newUri, 3);
            } else {
                URI newUri = this.options.effectiveServerUrlFollowRedirect(refreshUrl);
                newRequest2 = originalRequest.copy(newUri, 3);
            }
            newRequest2.setRequestMethod(IServerRequestFactory.REQUEST_TYPE_GET);
            if (newRequest2.hasSession()) {
                newRequest2.removeArgument("h_CAM_action");
            }
            return newRequest2;
        }
        if (htmlFormHandler.hasUpdatableElements()) {
            String value;
            HTFormElement[] formElements = htmlFormHandler.getFormElements();
            Vector<HTFormElement> missingCredentials = null;
            if (this.credentialPrompter == null) {
                missingCredentials = new Vector<HTFormElement>();
            }
            String signature = HtmlResponseHandler.generateSignature(formElements);
            Hashtable<String, String> credentials = this.options.getCredentials(signature, true);
            for (int idx = 0; idx < formElements.length; ++idx) {
                boolean missing = false;
                value = credentials == null ? null : (String)credentials.get(formElements[idx].getName());
                block1 : switch (formElements[idx].getType()) {
                    case 1: 
                    case 2: {
                        if (value == null) {
                            missing = true;
                            break;
                        }
                        formElements[idx].setValue(value);
                        break;
                    }
                    case 4: {
                        HTFormElement.DisplayValuePair[] displayValuePairs = formElements[idx].getDisplayValues();
                        if (value == null || value.length() == 0) {
                            missing = true;
                            break;
                        }
                        for (int j = 0; j < displayValuePairs.length; ++j) {
                            if (!displayValuePairs[j].value.equals(value)) continue;
                            formElements[idx].setSelectedDisplayValue(j);
                            break block1;
                        }
                        break;
                    }
                }
                if (!missing || missingCredentials == null) continue;
                missingCredentials.addElement(formElements[idx]);
            }
            if (missingCredentials != null && !missingCredentials.isEmpty()) {
                Object[] missingCredentialsA = new HTFormElement[missingCredentials.size()];
                missingCredentials.copyInto(missingCredentialsA);
                CMExceptionMissingCredentials e = new CMExceptionMissingCredentials((HTFormElement[])missingCredentialsA);
                VM.log(CLASS, 0, e.toString());
                throw e;
            }
            if (credentials == null) {
                credentials = new Hashtable<String, String>();
                VM.log(CLASS, 0, "no cached credentials for signature '" + signature + "'");
            } else {
                VM.log(CLASS, 0, "retrieved cached credentials for signature '" + signature + "'");
            }
            int result = 0;
            if (this.credentialPrompter != null) {
                taskMonitor.throwIfCancelled();
                result = this.credentialPrompter.promptCredentials(htmlFormHandler.getPageTitle(), htmlFormHandler.getFormElements(), request.isAnonymousEnabled() ? 1 : 0);
                VM.log(CLASS, 0, "finished prompting for credentials");
            }
            switch (result) {
                case 0: {
                    if (this.controller != null) {
                        this.controller.triggerSyncStartingNotification();
                    }
                    if (this.credentialPrompter != null) {
                        credentials.clear();
                        block23: for (int idx = 0; idx < formElements.length; ++idx) {
                            switch (formElements[idx].getType()) {
                                case 1: 
                                case 2: {
                                    value = formElements[idx].getValue();
                                    credentials.put(formElements[idx].getName(), value == null ? "" : value);
                                    continue block23;
                                }
                                case 4: {
                                    int sel = formElements[idx].getSelectedDisplayValue();
                                    HTFormElement.DisplayValuePair[] dvps = formElements[idx].getDisplayValues();
                                    if (sel < 0 || sel >= dvps.length) continue block23;
                                    credentials.put(formElements[idx].getName(), dvps[sel].value == null ? "" : dvps[sel].value);
                                }
                            }
                        }
                        this.options.setCredentials(signature, credentials);
                        this.options.save();
                    }
                    IServerRequest newRequest3 = originalRequest.copy(request.getUri(), 3);
                    HTFormElement[] missingFields = HtmlResponseHandler.buildResponseUrlForForm(htmlFormHandler.getFormElements(), credentials, newRequest3);
                    if (missingFields != null && missingFields.length > 0) {
                        CMExceptionMissingCredentials emc = new CMExceptionMissingCredentials(missingFields);
                        VM.log(CLASS, 3, emc.toString());
                        throw emc;
                    }
                    newRequest3.setRequestMethod(IServerRequestFactory.REQUEST_TYPE_POST);
                    VM.log(CLASS, 0, "processed form; supplied credentials");
                    if (htmlFormHandler.isOfflineLogin()) {
                        newRequest3.removeArgument("h_CAM_action");
                    }
                    return newRequest3;
                }
                case 1: {
                    if (htmlFormHandler.isOfflineLogin()) {
                        this.options.setCookie("cam_passport", null);
                    }
                    VM.log(CLASS, 1, "HtmlResponseHandler.handle: throwing CancellationException");
                    throw new CancellationException();
                }
                case 2: {
                    IServerRequest newRequest4 = originalRequest.copy(request.getUri(), 3);
                    newRequest4.removeArgument("h_CAM_action");
                    this.options.setCookie("CRN", null);
                    VM.log(CLASS, 0, "processed form; wants anonymous");
                    return newRequest4;
                }
            }
        } else {
            String errorCode = htmlFormHandler.getErrorCode();
            if (errorCode != null && errorCode.length() > 0) {
                if (errorCode.equals("CAM-AAA-0135") || errorCode.equals("AAA-AUT-0013") || errorCode.equals("CAM-AAA-0136") || errorCode.equals("CAM-AAA-0179") || errorCode.equals("AAA-AUT-0011")) {
                    VM.log(CLASS, 0, "CAM-AAA-0135 logged into all available namespaces");
                    IServerRequest newRequest5 = request.copy();
                    newRequest5.removeArgument("h_CAM_action");
                    VM.log(CLASS, 0, "logged into all namespaces; not forcing logon");
                    return newRequest5;
                }
                if (errorCode.equals("DPR-ERR-2022")) {
                    String message2 = "Received DPR-ERR-2022 from server which indicates that the Mobile Service is misconfigured or missing.";
                    VM.log(CLASS, 3, message2);
                    throw new CMException(1145);
                }
                if (errorCode.equals("DPR-ERR-2058")) {
                    String message3 = "Received DPR-ERR-2058 from server which indicates that the dispatcher hasn't finished initializing.";
                    VM.log(CLASS, 3, message3);
                    throw new CMException(1151);
                }
                if (errorCode.equals("DPR-ERR-2014")) {
                    String message4 = "Received DPR-ERR-2014 from server which indicates that the dispatcher can't find an instance of the Mobile service to load-balance the request to.";
                    VM.log(CLASS, 3, message4);
                    throw new CMException(1167);
                }
                if (errorCode.equals("CAM-AAA-0203")) {
                    String message5 = "Received CAM-AAA-0203 from the server, which indicates a security problem. You will need to log in again.";
                    VM.log(CLASS, 3, message5);
                    this.controller.logoff();
                    IServerRequest newRequest6 = request.copy();
                    return newRequest6;
                }
                String message6 = "Received error " + errorCode + " from server; page text is '" + htmlFormHandler.getPageText() + "'";
                VM.log(CLASS, 3, message6);
                throw new CMException(1152, new String[]{errorCode}, htmlFormHandler.getPageText());
            }
            if (htmlFormHandler.getFormAction() != null && htmlFormHandler.getFormAction().length() > 0) {
                HTFormElement[] elts = htmlFormHandler.getFormElements();
                URI uri = this.options.effectiveServerUrlFollowRedirect(htmlFormHandler.getFormAction());
                newRequest = request.copy(uri, 5);
                boolean containsHiddenFields = false;
                block24: for (int i = 0; i < elts.length; ++i) {
                    switch (elts[i].getType()) {
                        case 0: {
                            continue block24;
                        }
                        case 1: 
                        case 2: 
                        case 4: 
                        case 5: {
                            continue block24;
                        }
                        case 3: {
                            if (elts[i].getName() == null) continue block24;
                            newRequest.setArgument(elts[i].getName(), elts[i].getValue() != null ? elts[i].getValue() : "");
                            containsHiddenFields = true;
                        }
                    }
                }
                if (containsHiddenFields) {
                    return newRequest;
                }
            }
        }
        String pageText = htmlFormHandler.getPageText();
        if (pageText.indexOf("Your credentials are not valid for") >= 0) {
            message = "Received Siteminder login failure page";
            VM.log(CLASS, 1, message);
            this.controller.logoff();
            newRequest = originalRequest.copy(this.options.getEffectiveServerUri(), 3);
            newRequest.setRequestMethod(IServerRequestFactory.REQUEST_TYPE_GET);
            return newRequest;
        }
        if (pageText.indexOf("The IBM Cognos gateway is unable to connect to the IBM Cognos BI server") >= 0) {
            message = "Server isn't running";
            VM.log(CLASS, 1, message);
            throw new CMException(1159);
        }
        VM.log(CLASS, 3, "no error code: " + pageText);
        throw new CMException(1106, pageText);
    }

    private static HTFormElement[] buildResponseUrlForForm(HTFormElement[] formElements, Hashtable credentials, IServerRequest request) throws CMException {
        Vector<HTFormElement> missingFields = null;
        block6: for (int i = 0; i < formElements.length; ++i) {
            HTFormElement formElement = formElements[i];
            if (formElement.getName() == null) {
                VM.log(CLASS, 2, "ignoring form element with null name");
                continue;
            }
            String value = null;
            if (credentials != null) {
                value = (String)credentials.get(formElement.getName());
            }
            switch (formElement.getType()) {
                case 0: {
                    continue block6;
                }
                case 4: {
                    if (value == null) {
                        if (missingFields == null) {
                            missingFields = new Vector<HTFormElement>();
                        }
                        missingFields.addElement(formElement);
                    } else {
                        for (int j = 0; j < formElement.getDisplayValues().length; ++j) {
                            if (!value.equals(formElement.getDisplayValues()[j].display) && !value.equals(formElement.getDisplayValues()[j].value)) continue;
                            formElement.setValue(value);
                            break;
                        }
                    }
                    request.setArgument(formElement.getName(), CMUrlHelper.encodeUrl(formElement.getValue()));
                    continue block6;
                }
                case 1: 
                case 2: {
                    if (value == null) {
                        if (missingFields == null) {
                            missingFields = new Vector();
                        }
                        missingFields.addElement(formElement);
                    } else {
                        formElement.setValue(value);
                    }
                    request.setArgument(formElement.getName(), CMUrlHelper.encodeUrl(formElement.getValue()));
                    continue block6;
                }
                case 3: {
                    request.setArgument(formElement.getName(), CMUrlHelper.encodeUrl(formElement.getValue()));
                }
            }
        }
        if (missingFields == null) {
            return null;
        }
        Object[] ret = new HTFormElement[missingFields.size()];
        missingFields.copyInto(ret);
        return ret;
    }

    static String generateSignature(HTFormElement[] elements) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < elements.length; ++i) {
            switch (elements[i].getType()) {
                case 1: 
                case 2: 
                case 4: {
                    sb.append('(');
                    sb.append(elements[i].getName());
                    sb.append(')');
                }
            }
        }
        return sb.toString().toLowerCase();
    }
}

