/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.request;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMUrlConstants;
import com.cognos.mobile.request.BadServerResponseHandler;
import com.cognos.mobile.request.IRecoverableResponseHandler;
import com.cognos.mobile.request.IServerRequest;
import com.cognos.mobile.request.IServerRequestFactory;
import com.cognos.mobile.request.IServerResponse;
import com.cognos.mobile.request.URI;
import com.cognos.mobile.task.ITaskMonitor;
import com.cognos.mobile.vm.VMOptions;

public class HttpRedirectResponseHandler
implements IRecoverableResponseHandler {
    private static final Class CLASS = BadServerResponseHandler.class;
    private VMOptions options;

    public HttpRedirectResponseHandler(VMOptions options) {
        this.options = options;
    }

    @Override
    public boolean canHandle(IServerResponse response) throws CMException {
        switch (response.getResponseCode()) {
            case 301: 
            case 302: {
                return true;
            }
        }
        return false;
    }

    @Override
    public IServerRequest handle(IServerRequest originalRequest, IServerRequest request, IServerResponse response, ITaskMonitor taskMonitor) throws CMException {
        String location = response.getHeader(CMUrlConstants.HEADER_LOCATION);
        if (location == null || location.length() == 0) {
            throw new CMException(1156, new String[]{Integer.toString(response.getResponseCode())}, "no 'Location' header provided");
        }
        URI newUri = this.options.effectiveServerUrlFollowRedirect(location);
        IServerRequest newRequest = request.copy(newUri, 1);
        newRequest.setRequestMethod(IServerRequestFactory.REQUEST_TYPE_GET);
        return newRequest;
    }
}

