/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.request;

import com.cognos.mobile.cam.CAMCookie;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.common.ILogger;
import com.cognos.mobile.request.IServerResponse;
import com.cognos.mobile.request.URI;
import com.cognos.mobile.task.ICancellable;
import com.cognos.mobile.vm.VMOptions;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class IServerRequest
implements ICancellable {
    private static final Class CLASS = IServerRequest.class;
    protected final Hashtable contents = new Hashtable();
    protected final Hashtable headers = new Hashtable();
    protected int requestType;
    protected URI uri;
    private CAMCookie cookie;
    public static final String COOKIE = "Cookie";
    public static final String AUTHORIZATION = "Authorization";
    public static final int COPY_HEADERS = 1;
    public static final int COPY_BODY = 2;
    public static final int DO_NOT_MOVE_QUERY_INTO_BODY = 4;
    public static final int COPY_HEADERS_AND_BODY = 3;

    public IServerRequest(int requestType, URI uri) {
        this.requestType = requestType;
        this.uri = uri;
    }

    public void setRequestMethod(int requestType) {
        this.requestType = requestType;
    }

    public int getRequestMethod() {
        return this.requestType;
    }

    public boolean isAnonymousEnabled() {
        if (this.cookie != null) {
            return this.cookie.isCamConfiguredForAnonymous();
        }
        return false;
    }

    public boolean hasSession() {
        return this.cookie != null;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setArgument(String key, String value) throws CMException {
        this.contents.put(key, value);
    }

    public void setArgument(String key, int value) throws CMException {
        this.contents.put(key, Integer.toString(value));
    }

    public String getArgument(String key) throws CMException {
        return (String)this.contents.get(key);
    }

    public void removeArgument(String key) throws CMException {
        this.contents.remove(key);
    }

    public void setHeader(String header, String value) throws CMException {
        if (value == null || value.length() == 0) {
            this.headers.remove(header);
        } else {
            if (header.equalsIgnoreCase("cookie")) {
                int i = value.indexOf("cam_passport=");
                if (value.indexOf("mob_session") >= 0 && i >= 0) {
                    int j = value.indexOf(59, i);
                    String passport = value.substring(i + "cam_passport=".length(), j);
                    if (passport.length() > 0) {
                        this.cookie = new CAMCookie(passport);
                        value = value.substring(0, i + "cam_passport=".length()) + "\"" + passport + "\";" + (j >= 0 ? value.substring(j) : "");
                    }
                }
            }
            this.headers.put(header, value);
        }
    }

    public int getContentLength() {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        Enumeration keyEnum = this.contents.keys();
        while (keyEnum.hasMoreElements()) {
            String key = (String)keyEnum.nextElement();
            String value = (String)this.contents.get(key);
            if (first) {
                first = false;
            } else {
                buffer.append('&');
            }
            buffer.append(key);
            buffer.append('=');
            buffer.append(value);
        }
        return buffer.toString().length();
    }

    public String toString() {
        String value;
        String key;
        StringBuffer sb = new StringBuffer();
        sb.append("RIM server request URL '");
        sb.append(this.uri.toString());
        sb.append("', content ");
        sb.append("[");
        String sep = "";
        Enumeration keyEnum = this.contents.keys();
        while (keyEnum.hasMoreElements()) {
            key = (String)keyEnum.nextElement();
            value = (String)this.contents.get(key);
            sb.append(sep);
            sb.append(key);
            sb.append("=");
            if (value != null) {
                sb.append(value);
            }
            sep = ", ";
        }
        sb.append("]");
        sb.append("', headers ");
        sb.append("[");
        sep = "";
        keyEnum = this.headers.keys();
        while (keyEnum.hasMoreElements()) {
            key = (String)keyEnum.nextElement();
            value = (String)this.headers.get(key);
            sb.append(sep);
            sb.append(key);
            sb.append("=");
            if (value != null) {
                sb.append(value);
            }
            sep = ", ";
        }
        sb.append("]");
        return sb.toString();
    }

    public IServerRequest copy() throws CMException {
        String value;
        String key;
        IServerRequest copy = this.create(this.requestType, this.uri);
        Enumeration keyEnum = this.contents.keys();
        while (keyEnum.hasMoreElements()) {
            key = (String)keyEnum.nextElement();
            value = (String)this.contents.get(key);
            copy.contents.put(key, value);
        }
        Enumeration en = this.headers.keys();
        while (en.hasMoreElements()) {
            key = (String)en.nextElement();
            value = (String)this.headers.get(key);
            copy.setHeader(key, value);
        }
        return copy;
    }

    public IServerRequest copy(URI originalUri, int flags) throws CMException {
        String key;
        String query;
        URI uri = originalUri.copy();
        if ((flags & 4) == 0) {
            uri.setQuery("");
        }
        IServerRequest copy = this.create(this.requestType, uri);
        if ((flags & 4) == 0 && (query = originalUri.getQuery()) != null && query.length() > 0) {
            String[] args = CMStringHelper.split(query, '&', false);
            for (int i = 0; i < args.length; ++i) {
                int pos = args[i].indexOf(61);
                if (pos <= 0) continue;
                copy.setArgument(args[i].substring(0, pos), args[i].substring(pos + 1, args[i].length()));
            }
        }
        if ((flags & 2) != 0) {
            Enumeration keyEnum = this.contents.keys();
            while (keyEnum.hasMoreElements()) {
                key = (String)keyEnum.nextElement();
                String value = (String)this.contents.get(key);
                copy.contents.put(key, value);
            }
        }
        if ((flags & 1) != 0) {
            Enumeration en = this.headers.keys();
            while (en.hasMoreElements()) {
                key = (String)en.nextElement();
                String value = (String)this.headers.get(key);
                copy.setHeader(key, value);
            }
        }
        return copy;
    }

    public abstract IServerResponse execute(VMOptions var1, ILogger var2) throws CMException;

    protected abstract IServerRequest create(int var1, URI var2) throws CMException;
}

