/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.request;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.ICredentialPrompter;
import com.cognos.mobile.request.IServerRequest;
import com.cognos.mobile.request.URI;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMOptions;

public abstract class IServerRequestFactory {
    private static final Class CLASS = IServerRequestFactory.class;
    public static int REQUEST_TYPE_GET = 0;
    public static int REQUEST_TYPE_POST = 1;
    private final VMOptions options;
    private final ICredentialPrompter credentialPrompter;

    public IServerRequestFactory(VMOptions options, ICredentialPrompter credentialPrompter) {
        this.options = options;
        this.credentialPrompter = credentialPrompter;
    }

    public final IServerRequest createServerRequest(String path, int requestType) throws CMException {
        if (!this.options.serverUrlLooksOK() && this.credentialPrompter != null) {
            CMException lastEx = null;
            while (true) {
                VM.log(CLASS, 1, "IServerRequestFactory.createServerRequest: calling promptServerUrl");
                String newServerUrl = this.credentialPrompter.promptServerUrl(this.options.getServerUrl(), lastEx);
                try {
                    this.options.setServerUrl(newServerUrl, true);
                    this.options.save();
                }
                catch (CMException ex) {
                    lastEx = ex;
                    continue;
                }
                break;
            }
        }
        URI u = this.options.getEffectiveServerUri().copy();
        u.appendToPath("/mobileService/" + path);
        IServerRequest request = this.create(requestType, u);
        return request;
    }

    public final IServerRequest createServerRequest(int requestType) throws CMException {
        if (!this.options.serverUrlLooksOK() && this.credentialPrompter != null) {
            CMException lastEx = null;
            while (true) {
                VM.log(CLASS, 1, "IServerRequestFactory.createServerRequest: calling promptServerUrl");
                String newServerUrl = this.credentialPrompter.promptServerUrl(this.options.getServerUrl(), lastEx);
                try {
                    this.options.setServerUrl(newServerUrl, true);
                    this.options.save();
                }
                catch (CMException ex) {
                    lastEx = ex;
                    continue;
                }
                break;
            }
        }
        IServerRequest request = this.create(requestType, this.options.getEffectiveServerUri().copy());
        request.setArgument("b_action", "mobileService");
        return request;
    }

    protected final VMOptions getOptions() {
        return this.options;
    }

    protected abstract IServerRequest create(int var1, URI var2) throws CMException;
}

