/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.request;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMServerHelper;
import com.cognos.mobile.common.ICMImageFactory;
import com.cognos.mobile.common.MobileServiceProxy;
import com.cognos.mobile.request.IRecoverableResponseHandler;
import com.cognos.mobile.request.IServerRequest;
import com.cognos.mobile.request.IServerResponse;
import com.cognos.mobile.task.ITaskMonitor;
import com.cognos.mobile.vm.IVMImage;
import com.cognos.mobile.vm.VMScene;

public class ImageHandler
implements IRecoverableResponseHandler {
    private static final String SIGNATURE = "<meta name=\"type\" content=\"tiles\"/>";
    private final VMScene scene;
    private final ICMImageFactory imageFactory;
    private final MobileServiceProxy service;
    private IVMImage image;

    public ImageHandler(VMScene scene, ICMImageFactory imageFactory, MobileServiceProxy service) {
        this.scene = scene;
        this.imageFactory = imageFactory;
        this.service = service;
    }

    @Override
    public boolean canHandle(IServerResponse response) throws CMException {
        if (response.getResponseCode() != 200) {
            return false;
        }
        if (CMServerHelper.mimeTypeToImage(response.getContentType()) == 3) {
            return response.responseBodyContains(SIGNATURE);
        }
        return CMServerHelper.mimeTypeToImage(response.getContentType()) != 0;
    }

    @Override
    public IServerRequest handle(IServerRequest originalRequest, IServerRequest request, IServerResponse response, ITaskMonitor taskMonitor) throws CMException {
        this.image = this.imageFactory.create(this.scene, this.service, response);
        return null;
    }

    public IVMImage getImage() {
        return this.image;
    }
}

