/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.request;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMUrlConstants;
import com.cognos.mobile.request.IRecoverableResponseHandler;
import com.cognos.mobile.request.IServerRequest;
import com.cognos.mobile.request.IServerResponse;
import com.cognos.mobile.task.ITaskMonitor;
import java.io.IOException;
import java.io.InputStream;

public class KeyResponseHandler
implements IRecoverableResponseHandler {
    private String keyType;
    private byte[] key;

    @Override
    public boolean canHandle(IServerResponse response) throws CMException {
        return response.getResponseCode() == 200 && response.getContentType().equals(CMUrlConstants.CONTENT_TYPE_MOB_KEY);
    }

    @Override
    public IServerRequest handle(IServerRequest originalRequest, IServerRequest request, IServerResponse response, ITaskMonitor taskMonitor) throws CMException {
        this.keyType = response.getHeader(CMUrlConstants.HEADER_KEY_TYPE);
        this.key = this.keyType != null ? (this.keyType.startsWith(CMUrlConstants.KEY_AES_128) ? new byte[16] : (this.keyType.startsWith(CMUrlConstants.KEY_AES_192) ? new byte[24] : (this.keyType.startsWith(CMUrlConstants.KEY_AES_256) ? new byte[32] : new byte[0]))) : new byte[0];
        if (this.key.length > 0) {
            InputStream inputStream = response.getInputStream();
            int pos = 0;
            try {
                int bytesRead;
                while ((bytesRead = inputStream.read(this.key, pos, this.key.length - pos)) > 0 && (pos += bytesRead) < this.key.length) {
                }
            }
            catch (IOException ioe) {
                throw new CMException(2003, (Throwable)ioe);
            }
        }
        return null;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public byte[] getKey() {
        return this.key;
    }
}

