/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.request;

import com.cognos.mobile.client.IClientApplication;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMIDs;
import com.cognos.mobile.common.CMUrlConstants;
import com.cognos.mobile.location.ILocationProvider;
import com.cognos.mobile.location.LocationServices;
import com.cognos.mobile.request.IRecoverableResponseHandler;
import com.cognos.mobile.request.IServerRequest;
import com.cognos.mobile.request.IServerResponse;
import com.cognos.mobile.task.ITaskMonitor;
import com.cognos.mobile.vm.VMOptions;

public class LocationNeededResponseHandler
implements IRecoverableResponseHandler {
    private final VMOptions options;
    private LocationServices locationServices;
    private IClientApplication clientApplication;

    public LocationNeededResponseHandler(VMOptions options) {
        this.options = options;
    }

    public void setLocationServices(LocationServices locationServices) {
        this.locationServices = locationServices;
    }

    public void setClientApplication(IClientApplication clientApplication) {
        this.clientApplication = clientApplication;
    }

    @Override
    public boolean canHandle(IServerResponse response) throws CMException {
        return response.getResponseCode() == 200 && response.getContentType().equalsIgnoreCase("text/xml") && response.responseBodyContains("location-needed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IServerRequest handle(IServerRequest originalRequest, IServerRequest request, IServerResponse response, ITaskMonitor taskMonitor) throws CMException {
        int useLocation = this.options.getUseLocation();
        if (useLocation == 1) {
            useLocation = this.clientApplication.askYesNoQuestion(CMIDs.OPTIONS_LOCATION, CMIDs.LOCATION_USE_1) == 1 ? 2 : 0;
        }
        IServerRequest newRequest = request.copy();
        switch (useLocation) {
            case 2: {
                String[] oldDescriptions = taskMonitor.getDescriptions();
                try {
                    taskMonitor.setDescriptions(CMIDs.LOCATION_READING, CMIDs.COMPILE_REPORT_2, CMIDs.COMPILE_REPORT_BUTTON);
                    ILocationProvider.Loc location = this.locationServices.getLocation();
                    taskMonitor.setDescriptions(CMIDs.COMPILE_REPORT_1, CMIDs.COMPILE_REPORT_2, CMIDs.COMPILE_REPORT_BUTTON);
                    newRequest.removeArgument(CMUrlConstants.PARAM_LOCATION_AVAILABLE[0]);
                    newRequest.setArgument(CMUrlConstants.PARAM_LOCATION_LATITUDE[0], Double.toString(location.latitude));
                    newRequest.setArgument(CMUrlConstants.PARAM_LOCATION_LONGITUDE[0], Double.toString(location.longitude));
                    newRequest.setArgument(CMUrlConstants.PARAM_LOCATION_ACCURACY[0], Double.toString(location.accuracy));
                    break;
                }
                finally {
                    taskMonitor.setDescriptions(oldDescriptions[0], oldDescriptions[1], oldDescriptions[2]);
                }
            }
            case 0: {
                newRequest.setArgument(CMUrlConstants.PARAM_LOCATION_AVAILABLE[0], "false");
            }
        }
        return newRequest;
    }
}

