/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.request;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.ICMXMLParserFactory;
import com.cognos.mobile.request.IRecoverableResponseHandler;
import com.cognos.mobile.request.IServerRequest;
import com.cognos.mobile.request.IServerResponse;
import com.cognos.mobile.task.ITaskMonitor;
import com.cognos.mobile.xml.IXMLParser;
import com.cognos.mobile.xml.XMLFailureResponseHandler;
import java.io.IOException;
import org.xml.sax.SAXException;

public class MobXmlFailureResponseHandler
implements IRecoverableResponseHandler {
    private final String SIGNATURE = "<response status=\"failure\">";
    private final ICMXMLParserFactory xmlParserFactory;
    private final XMLFailureResponseHandler xmlResponseHandler;

    public MobXmlFailureResponseHandler(ICMXMLParserFactory xmlParserFactory) {
        this.xmlParserFactory = xmlParserFactory;
        this.xmlResponseHandler = new XMLFailureResponseHandler();
    }

    @Override
    public boolean canHandle(IServerResponse response) throws CMException {
        return response.getResponseCode() == 200 && response.getContentType().equalsIgnoreCase("text/xml") && response.responseBodyContains("<response status=\"failure\">");
    }

    @Override
    public IServerRequest handle(IServerRequest originalRequest, IServerRequest request, IServerResponse response, ITaskMonitor taskMonitor) throws CMException {
        try {
            IXMLParser xmlParser = this.xmlParserFactory.create();
            this.xmlResponseHandler.doParse(xmlParser, response.getInputStream());
            if (this.xmlResponseHandler.success()) {
                throw new CMException(1157, "failure response handler was mistakenly given a successful response");
            }
            if (this.xmlResponseHandler.getErrorCode() == 1112) {
                IServerRequest newRequest = request.copy();
                newRequest.setArgument("h_CAM_action", "logonAs");
                return newRequest;
            }
            if (this.xmlResponseHandler.getErrorCode() == 1175 && response.isAnonymousEnabled() && request.getArgument("h_CAM_action") == null) {
                IServerRequest newRequest = request.copy();
                newRequest.setArgument("h_CAM_action", "logonAs");
                return newRequest;
            }
            throw new CMException(this.xmlResponseHandler.getErrorCode(), this.xmlResponseHandler.getErrorParams(), this.xmlResponseHandler.getErrorDetails());
        }
        catch (SAXException ex) {
            throw new CMException(1157, (Throwable)ex);
        }
        catch (IOException ex) {
            throw new CMException(1157, (Throwable)ex);
        }
    }
}

