/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.request;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMIntSet;
import com.cognos.mobile.common.ICMXMLParserFactory;
import com.cognos.mobile.configuration.HashtableConfiguration;
import com.cognos.mobile.event.IServerResponseListener;
import com.cognos.mobile.request.IRecoverableResponseHandler;
import com.cognos.mobile.request.IServerRequest;
import com.cognos.mobile.request.IServerResponse;
import com.cognos.mobile.task.ITaskMonitor;
import com.cognos.mobile.task.InvisibleTaskMonitor;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.xml.IXMLParser;
import com.cognos.mobile.xml.XMLResponseHandler;
import java.io.IOException;
import java.util.Hashtable;
import org.xml.sax.SAXException;

public class MobXmlResponseHandler
implements IRecoverableResponseHandler {
    private static final Class CLASS = MobXmlResponseHandler.class;
    public static final String SIGNATURE = "<response status=\"success\">";
    private final ICMXMLParserFactory xmlParserFactory;
    private final XMLResponseHandler xmlResponseHandler;
    private final IServerResponseListener serverResponseListener;

    public MobXmlResponseHandler(IServerResponseListener serverResponseListener, ICMXMLParserFactory xmlParserFactory, XMLResponseHandler xmlResponseHandler) {
        this.xmlParserFactory = xmlParserFactory;
        this.xmlResponseHandler = xmlResponseHandler;
        this.serverResponseListener = serverResponseListener;
    }

    @Override
    public boolean canHandle(IServerResponse response) throws CMException {
        return response.getResponseCode() == 200 && response.getContentType().equalsIgnoreCase("text/xml") && response.responseBodyContains(SIGNATURE);
    }

    @Override
    public IServerRequest handle(IServerRequest originalRequest, IServerRequest request, IServerResponse response, ITaskMonitor taskMonitor) throws CMException {
        try {
            CMIntSet s2Inbox;
            int nextCall;
            IXMLParser xmlParser = this.xmlParserFactory.create();
            this.xmlResponseHandler.doParse(xmlParser, response.getInputStream());
            if (!this.xmlResponseHandler.success()) {
                VM.log(CLASS, 0, "problem parsing response");
                throw new CMException(1157, "failed to parse response");
            }
            Hashtable settings = this.xmlResponseHandler.getSettings();
            if (settings != null) {
                this.serverResponseListener.setSettings(new HashtableConfiguration(settings));
            }
            if ((nextCall = this.xmlResponseHandler.nextCallInSeconds()) > 0) {
                if (taskMonitor != null && !taskMonitor.isCancelled() && !(taskMonitor instanceof InvisibleTaskMonitor)) {
                    this.serverResponseListener.setNextCall(5);
                } else {
                    this.serverResponseListener.setNextCall(nextCall);
                }
            }
            if ((s2Inbox = this.xmlResponseHandler.getS2Inbox()) != null) {
                this.serverResponseListener.setS2Inbox(s2Inbox);
            }
            return null;
        }
        catch (SAXException ex) {
            throw new CMException(1157, (Throwable)ex);
        }
        catch (IOException ex) {
            throw new CMException(1157, (Throwable)ex);
        }
    }
}

