/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.request;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMUrlConstants;
import com.cognos.mobile.request.IRecoverableResponseHandler;
import com.cognos.mobile.request.IServerRequest;
import com.cognos.mobile.request.IServerResponse;
import com.cognos.mobile.task.ITaskMonitor;
import com.cognos.mobile.vm.VM;

public class OtherAuthenticationFaultHandler
implements IRecoverableResponseHandler {
    private static final Class CLASS = OtherAuthenticationFaultHandler.class;

    @Override
    public boolean canHandle(IServerResponse response) throws CMException {
        String authenticateHeader;
        return response.getResponseCode() == 401 && ((authenticateHeader = response.getHeader(CMUrlConstants.HEADER_AUTHENTICATE)) == null || !authenticateHeader.toLowerCase().startsWith("basic"));
    }

    @Override
    public IServerRequest handle(IServerRequest originalRequest, IServerRequest request, IServerResponse response, ITaskMonitor taskMonitor) throws CMException {
        String authenticateHeader = response.getHeader(CMUrlConstants.HEADER_AUTHENTICATE);
        if (authenticateHeader == null) {
            authenticateHeader = "(unknown)";
        }
        VM.log(CLASS, 3, "unsupported HTTP authenticate protocol: " + authenticateHeader);
        throw new CMException(1158, new String[]{authenticateHeader});
    }
}

