/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.request;

import com.cognos.mobile.common.CMBase64;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMUrlConstants;
import com.cognos.mobile.common.CMUrlHelper;
import com.cognos.mobile.common.ICMXMLParserFactory;
import com.cognos.mobile.common.IPromptPrompter;
import com.cognos.mobile.common.MobileServiceProxy;
import com.cognos.mobile.jzlib.ZInputStream;
import com.cognos.mobile.jzlib.ZOutputStream;
import com.cognos.mobile.prompts.Conversation;
import com.cognos.mobile.prompts.Prompts;
import com.cognos.mobile.prompts.PromptsContentHandler;
import com.cognos.mobile.request.IRecoverableResponseHandler;
import com.cognos.mobile.request.IServerRequest;
import com.cognos.mobile.request.IServerResponse;
import com.cognos.mobile.task.ITaskMonitor;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMOptions;
import com.cognos.mobile.xml.IXMLParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.SAXException;

public class PromptHandler
implements IRecoverableResponseHandler {
    private static Class CLASS = PromptHandler.class;
    private static final int CHUNK_SIZE = 1600;
    private static final int RIM_CHUNK_SIZE = 128000;
    private static final String SIGNATURE = "<rds:describePrompts";
    private static final String SIGNATURE2 = "<rds:GetPromptDescriptionResponse";
    private final ICMXMLParserFactory xmlPFact;
    private final IPromptPrompter prompter;
    private final PromptsContentHandler promptsContentHandler;
    private final MobileServiceProxy proxy;
    private Conversation conversation;
    private final VMOptions options;

    public PromptHandler(ICMXMLParserFactory xmlPFact, IPromptPrompter prompter, MobileServiceProxy proxy, VMOptions options) {
        this.xmlPFact = xmlPFact;
        this.prompter = prompter;
        this.proxy = proxy;
        this.promptsContentHandler = new PromptsContentHandler();
        this.options = options;
    }

    @Override
    public boolean canHandle(IServerResponse response) throws CMException {
        if (response.getContentType().equals(CMUrlConstants.CONTENT_TYPE_MOB_PROMPT_COMPRESSED)) {
            return response.getResponseCode() == 200;
        }
        return response.getResponseCode() == 200 && response.getContentType().equalsIgnoreCase("text/xml") && response.responseBodyContains("<response status=\"success\">") && (response.responseBodyContains(SIGNATURE) || response.responseBodyContains(SIGNATURE2));
    }

    @Override
    public IServerRequest handle(IServerRequest originalRequest, IServerRequest request, IServerResponse response, ITaskMonitor taskMonitor) throws CMException {
        IXMLParser p = this.xmlPFact.create();
        try {
            InputStream in;
            if (response.getContentType().equals(CMUrlConstants.CONTENT_TYPE_MOB_PROMPT_COMPRESSED)) {
                ZInputStream zipInput = new ZInputStream(response.getInputStream());
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buffer = new byte[8192];
                int count = -1;
                while ((count = zipInput.read(buffer, 0, buffer.length)) > 0) {
                    out.write(buffer, 0, count);
                }
                in = new ByteArrayInputStream(out.toByteArray());
            } else {
                in = response.getInputStream();
            }
            p.parse(in, this.promptsContentHandler);
            Prompts prompts = this.promptsContentHandler.getPrompts();
            VM.log(CLASS, 0, "Prompts: " + prompts);
            if (prompts != null && prompts.listPromptItems().length > 0 && this.prompter.prompt(prompts)) {
                if (this.conversation != null && this.conversation.getId() != null && this.conversation.getId().equals(prompts.getConversationId())) {
                    this.conversation.add(prompts);
                } else {
                    this.conversation = new Conversation(prompts);
                }
                IServerRequest newRequest = request.copy();
                String answers = this.conversation.asPromptAnswers();
                VM.log(CLASS, 0, answers);
                int chunkSize = 0;
                if ("RIM" == this.options.getPlatform()) {
                    chunkSize = this.options.getBBMaxMessageSizeBytes();
                    if (chunkSize <= 0) {
                        chunkSize = 128000;
                    }
                } else {
                    chunkSize = 1600;
                }
                if (prompts.reprompt()) {
                    newRequest.setArgument(CMUrlConstants.PARAM_REPROMPT[0], "true");
                } else {
                    newRequest.setArgument(CMUrlConstants.PARAM_REPROMPT[0], "false");
                }
                if (newRequest.getContentLength() + CMUrlHelper.encodeUrl(answers).length() + CMUrlConstants.PARAM_CONTENT_BODY[0].length() + 2 > chunkSize) {
                    String[] chunks = PromptHandler.chunker(answers, chunkSize);
                    int id = this.proxy.chunkRequest(taskMonitor, CMUrlHelper.encodeUrl(chunks[0]));
                    for (int i = 1; i < chunks.length; ++i) {
                        this.proxy.appendChunk(id, taskMonitor, CMUrlHelper.encodeUrl(chunks[i]));
                    }
                    newRequest.setArgument(CMUrlConstants.PARAM_TEMP_STOREID[0], "/tmp/" + id);
                    newRequest.removeArgument(CMUrlConstants.PARAM_CONTENT_BODY[0]);
                } else {
                    newRequest.setArgument(CMUrlConstants.PARAM_CONTENT_BODY[0], CMUrlHelper.encodeUrl(answers));
                    newRequest.removeArgument(CMUrlConstants.PARAM_TEMP_STOREID[0]);
                }
                if (prompts.getTid() != null) {
                    newRequest.setArgument(CMUrlConstants.PARAM_BUX_TEMPID[0], prompts.getTid());
                }
                if (prompts.getWid() != null) {
                    newRequest.setArgument(CMUrlConstants.PARAM_WIDGETID[0], prompts.getWid());
                }
                if (prompts.getBuxStoreIDs() != null) {
                    newRequest.setArgument(CMUrlConstants.PARAM_WIDGET_STOREIDS[0], prompts.getBuxStoreIDs());
                }
                return newRequest;
            }
        }
        catch (IOException ioe) {
            VM.log(CLASS, 3, ioe);
        }
        catch (SAXException saxe) {
            VM.log(CLASS, 3, saxe);
        }
        return null;
    }

    private static String[] chunker(String answers, int chunkSize) throws IOException {
        int i;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZOutputStream zout = new ZOutputStream(baos, 9);
        zout.write(answers.getBytes("UTF-8"));
        zout.flush();
        zout.close();
        String encoded = CMBase64.encodeBytes(baos.toByteArray(), 8);
        int chunks = encoded.length() / chunkSize;
        int remainder = encoded.length() % chunkSize;
        String[] result = remainder > 0 ? new String[chunks + 1] : new String[chunks];
        for (i = 0; i < chunks; ++i) {
            result[i] = encoded.substring(i * chunkSize, i * chunkSize + chunkSize);
        }
        if (remainder > 0) {
            result[i] = encoded.substring(i * chunkSize, i * chunkSize + remainder);
        }
        return result;
    }
}

