/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.request;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.ICMXMLParserFactory;
import com.cognos.mobile.request.IRecoverableResponseHandler;
import com.cognos.mobile.request.IServerRequest;
import com.cognos.mobile.request.IServerResponse;
import com.cognos.mobile.request.SoapEnvelopeParser;
import com.cognos.mobile.task.ITaskMonitor;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.xml.IXMLParser;
import java.io.IOException;
import org.xml.sax.SAXException;

public class SoapResponseHandler
implements IRecoverableResponseHandler {
    private static final String SIGNATURE = "<SOAP-ENV:Envelope";
    private static final Class CLASS = SoapResponseHandler.class;
    private ICMXMLParserFactory xmlParserFactory;

    public SoapResponseHandler(ICMXMLParserFactory xmlParserFactory) {
        this.xmlParserFactory = xmlParserFactory;
    }

    @Override
    public boolean canHandle(IServerResponse response) throws CMException {
        return response.getResponseCode() == 200 && response.getContentType().startsWith("text/xml") && response.responseBodyContains(SIGNATURE);
    }

    @Override
    public IServerRequest handle(IServerRequest originalRequest, IServerRequest request, IServerResponse response, ITaskMonitor taskMonitor) throws CMException {
        try {
            IXMLParser xmlParser = this.xmlParserFactory.create();
            SoapEnvelopeParser envelopeParser = new SoapEnvelopeParser();
            envelopeParser.doParse(xmlParser, response.getInputStream());
            if (envelopeParser.isFault()) {
                String faultCode = envelopeParser.getFaultCode();
                if (faultCode.equals("SERVER_NOT_AVAILABLE")) {
                    VM.log(CLASS, 2, "Server not available");
                    throw new CMException(1159);
                }
                VM.log(CLASS, 2, "Received unknown faultcode " + faultCode + ", fault string '" + envelopeParser.getFaultString() + "'");
                throw new CMException(1152, new String[]{faultCode}, envelopeParser.getFaultString());
            }
            throw new CMException(1157, "received SOAP envelope");
        }
        catch (SAXException ex) {
            throw new CMException(1157, (Throwable)ex);
        }
        catch (IOException ex) {
            throw new CMException(1157, (Throwable)ex);
        }
    }
}

