/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.request;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper;
import java.util.Hashtable;
import java.util.Vector;

public class URI {
    public static final int SCHEME_OR_HOST_OR_PATH_OR_QUERY = 0;
    public static final int HOST_OR_PATH_2 = 3;
    public static final int HOST = 4;
    public static final int PORT = 5;
    public static final int PATH = 6;
    public static final int QUERY = 7;
    public static final int HOST_OR_PATH_1 = 8;
    private String scheme = "";
    private String host = "";
    private String query = "";
    private String[] paths = null;
    private boolean leadingSlash = false;
    private boolean trailingSlash = false;
    private int port = 80;
    private Class CLASS = URI.class;

    private URI() {
    }

    private static StringBuffer _handlePathElement(URI response, StringBuffer pathElement, Vector pathElements) {
        String p = pathElement.toString();
        if (p.length() != 0 && !p.equals(".")) {
            if (p.equals("..")) {
                if (pathElements.size() > 0 && !pathElements.elementAt(pathElements.size() - 1).equals("..")) {
                    pathElements.removeElementAt(pathElements.size() - 1);
                } else {
                    pathElements.addElement(p);
                }
            } else {
                pathElements.addElement(p);
            }
        }
        return new StringBuffer();
    }

    public static URI parseURI(String uri, boolean gateway) throws CMException {
        if (uri == null || uri.length() == 0) {
            return new URI();
        }
        char[] chars = uri.toCharArray();
        URI response = new URI();
        int state = 0;
        StringBuffer sb = new StringBuffer();
        Vector<String> ps = new Vector<String>();
        block22: for (int i = 0; i < chars.length; ++i) {
            switch (state) {
                case 0: {
                    if (chars[i] == ':') {
                        response.scheme = sb.toString();
                        sb = new StringBuffer();
                        state = 8;
                        continue block22;
                    }
                    if (chars[i] == '/') {
                        String p = sb.toString();
                        if (p.length() == 0) {
                            response.leadingSlash = true;
                        } else {
                            ps.addElement(p);
                        }
                        response.trailingSlash = true;
                        sb = new StringBuffer();
                        state = 6;
                        continue block22;
                    }
                    if (URI.isAlpha(chars[i])) {
                        sb.append(chars[i]);
                        continue block22;
                    }
                    if (chars[i] == '?') {
                        sb = URI._handlePathElement(response, sb, ps);
                        state = 7;
                        continue block22;
                    }
                    sb.append(chars[i]);
                    state = 6;
                    continue block22;
                }
                case 8: {
                    if (chars[i] == '/') {
                        state = 3;
                        continue block22;
                    }
                    if (chars[i] == '?') {
                        sb = URI._handlePathElement(response, sb, ps);
                        state = 7;
                        continue block22;
                    }
                    throw new CMException(1006, uri);
                }
                case 3: {
                    if (chars[i] == '/') {
                        state = 4;
                        continue block22;
                    }
                    response.leadingSlash = true;
                    state = 6;
                    continue block22;
                }
                case 4: {
                    if (chars[i] == ':') {
                        response.host = sb.toString();
                        sb = new StringBuffer();
                        state = 5;
                        continue block22;
                    }
                    if (chars[i] == '/') {
                        response.host = sb.toString();
                        sb = new StringBuffer();
                        response.leadingSlash = true;
                        state = 6;
                        continue block22;
                    }
                    if (chars[i] == '?') {
                        throw new CMException(1006, uri);
                    }
                    sb.append(chars[i]);
                    continue block22;
                }
                case 5: {
                    if (URI.isNumeric(chars[i])) {
                        sb.append(chars[i]);
                        continue block22;
                    }
                    if (chars[i] == '/') {
                        try {
                            response.port = Integer.parseInt(sb.toString());
                        }
                        catch (NumberFormatException nfe) {
                            throw new CMException(1006, uri);
                        }
                        response.leadingSlash = true;
                        sb = new StringBuffer();
                        state = 6;
                        continue block22;
                    }
                    throw new CMException(1006, uri);
                }
                case 6: {
                    if (!gateway && chars[i] == '?' || gateway && chars[i] == '/') {
                        sb = URI._handlePathElement(response, sb, ps);
                        state = 7;
                        continue block22;
                    }
                    if (chars[i] == '/') {
                        sb = URI._handlePathElement(response, sb, ps);
                        response.trailingSlash = true;
                        continue block22;
                    }
                    sb.append(chars[i]);
                    if (chars[i] == '.') continue block22;
                    response.trailingSlash = false;
                    continue block22;
                }
                case 7: {
                    sb.append(chars[i]);
                }
            }
        }
        switch (state) {
            case 0: {
                if (sb.length() == 0) {
                    return null;
                }
                URI._handlePathElement(response, sb, ps);
                break;
            }
            case 8: {
                throw new CMException(1006, uri);
            }
            case 3: {
                response.leadingSlash = true;
                break;
            }
            case 4: {
                if (sb.length() == 0) {
                    throw new CMException(1006, uri);
                }
                response.host = sb.toString();
                response.port = 80;
                break;
            }
            case 5: {
                if (sb.length() == 0) {
                    throw new CMException(1006, uri);
                }
                try {
                    response.port = Integer.parseInt(sb.toString());
                    break;
                }
                catch (NumberFormatException nfe) {
                    throw new CMException(1006, uri);
                }
            }
            case 6: {
                URI._handlePathElement(response, sb, ps);
                break;
            }
            case 7: {
                response.query = sb.toString();
            }
        }
        response.paths = new String[ps.size()];
        ps.copyInto(response.paths);
        if (response.leadingSlash && response.paths.length == 0) {
            response.trailingSlash = false;
        }
        return response;
    }

    public void followRedirect(URI redirect) {
        if (redirect.host != null && redirect.host.length() > 0) {
            this.host = redirect.host;
            this.port = redirect.port;
            this.leadingSlash = redirect.leadingSlash;
            this.paths = redirect.paths;
            this.trailingSlash = redirect.trailingSlash;
            this.query = redirect.query;
        } else {
            if (redirect.leadingSlash) {
                this.leadingSlash = redirect.leadingSlash;
                this.paths = redirect.paths;
                this.trailingSlash = redirect.trailingSlash;
            } else if (redirect.paths == null || redirect.paths.length == 0) {
                if (redirect.query == null || redirect.query.length() == 0) {
                    if (!this.trailingSlash && this.paths.length > 0) {
                        String[] oldPaths = this.paths;
                        this.paths = new String[oldPaths.length - 1];
                        System.arraycopy(oldPaths, 0, this.paths, 0, oldPaths.length - 1);
                        this.trailingSlash = true;
                    }
                } else {
                    this.query = redirect.query;
                }
            } else {
                int rightLength;
                int leftLength = this.trailingSlash ? this.paths.length : this.paths.length - 1;
                int rightStart = 0;
                for (rightLength = redirect.paths.length; leftLength > 0 && rightStart <= rightLength && redirect.paths[rightStart].equals(".."); ++rightStart, --rightLength) {
                    if (--leftLength > 0) continue;
                    leftLength = 0;
                }
                if (leftLength + rightLength == 0) {
                    this.paths = null;
                } else {
                    String[] oldLeftPaths = this.paths;
                    this.paths = new String[leftLength + rightLength];
                    System.arraycopy(oldLeftPaths, 0, this.paths, 0, leftLength);
                    System.arraycopy(redirect.paths, rightStart, this.paths, leftLength, rightLength);
                    this.trailingSlash = rightLength > 0 ? redirect.trailingSlash : true;
                }
            }
            this.query = redirect.query;
        }
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        StringBuffer sb = new StringBuffer();
        if (this.leadingSlash) {
            sb.append("/");
        }
        if (this.paths != null) {
            boolean first = true;
            for (int i = 0; i < this.paths.length; ++i) {
                if (first) {
                    first = false;
                } else {
                    sb.append("/");
                }
                sb.append(this.paths[i]);
            }
            if (this.trailingSlash) {
                sb.append("/");
            }
        }
        return sb.toString();
    }

    public String getQuery() {
        return this.query;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String toString() {
        return (this.scheme == null || this.scheme.length() == 0 ? "" : this.scheme + "://") + this.host + (this.port == 80 ? "" : ":" + this.port) + this.getPath() + (this.query == null || this.query.length() == 0 ? "" : "?" + this.query);
    }

    public URI copy() {
        URI copy = new URI();
        copy.scheme = this.scheme;
        copy.host = this.host;
        copy.port = this.port;
        copy.leadingSlash = this.leadingSlash;
        copy.paths = new String[this.paths.length];
        System.arraycopy(this.paths, 0, copy.paths, 0, this.paths.length);
        copy.trailingSlash = this.trailingSlash;
        copy.query = this.query;
        return copy;
    }

    public Hashtable getArguments() {
        if (this.query == null) {
            return null;
        }
        String[] queries = CMStringHelper.split(this.query, '&', false);
        Hashtable<String, String> ret = new Hashtable<String, String>();
        for (int i = 0; i < queries.length; ++i) {
            int p = queries[i].indexOf(61);
            if (i <= 0) continue;
            ret.put(queries[i].substring(0, p), queries[i].substring(p + 1, queries[i].length()));
        }
        return ret;
    }

    public void appendToPath(String addition) throws CMException {
        URI a = URI.parseURI(addition, false);
        if (a.paths.length > 0) {
            String[] oldPaths = this.paths;
            this.paths = new String[oldPaths.length + a.paths.length];
            System.arraycopy(oldPaths, 0, this.paths, 0, oldPaths.length);
            System.arraycopy(a.paths, 0, this.paths, oldPaths.length, a.paths.length);
            this.trailingSlash = a.trailingSlash;
        }
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof URI)) {
            return false;
        }
        URI r = (URI)rhs;
        if (CMStringHelper.compareStrings(this.scheme, r.scheme) != 0) {
            return false;
        }
        if (CMStringHelper.compareStrings(this.host, r.host) != 0) {
            return false;
        }
        if (this.port != r.port) {
            return false;
        }
        if (this.paths.length != r.paths.length) {
            return false;
        }
        if (CMStringHelper.compareStrings(this.query, r.query) != 0) {
            return false;
        }
        for (int i = 0; i < this.paths.length; ++i) {
            if (this.paths[i].equals(r.paths[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isAlpha(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean isNumeric(char c) {
        return c >= '0' && c <= '9';
    }
}

