/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.request;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.request.BadServerResponseHandler;
import com.cognos.mobile.request.IRecoverableResponseHandler;
import com.cognos.mobile.request.IServerRequest;
import com.cognos.mobile.request.IServerResponse;
import com.cognos.mobile.task.ITaskMonitor;
import com.cognos.mobile.vm.VM;

public class UnrecoverableHttpErrorResponseHandler
implements IRecoverableResponseHandler {
    private static final Class CLASS = BadServerResponseHandler.class;

    @Override
    public boolean canHandle(IServerResponse response) throws CMException {
        switch (response.getResponseCode()) {
            case 403: 
            case 413: {
                return true;
            }
        }
        return false;
    }

    @Override
    public IServerRequest handle(IServerRequest originalRequest, IServerRequest request, IServerResponse response, ITaskMonitor taskMonitor) throws CMException {
        switch (response.getResponseCode()) {
            case 403: {
                VM.log(CLASS, 2, "received HTTP 403 FORBIDDEN response");
                throw new CMException(1163);
            }
            case 413: {
                VM.log(CLASS, 2, "received HTTP 413 TOO LARGE response");
                throw new CMException(1164);
            }
        }
        throw new CMException(1000, "internal error, handler received invalid response");
    }
}

