/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.request.se;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.ILogger;
import com.cognos.mobile.request.IServerRequest;
import com.cognos.mobile.request.IServerResponse;
import com.cognos.mobile.request.URI;
import com.cognos.mobile.request.se.BasicServerResponse;
import com.cognos.mobile.request.se.ServerRequest;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMOptions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;
import org.apache.axis.encoding.Base64;

public class BasicServerRequest
extends IServerRequest {
    private static final Class CLASS = ServerRequest.class;
    private volatile HttpURLConnection connection;

    public BasicServerRequest(String url) throws CMException {
        super(0, null);
        try {
            this.commonConstruct(new URL(url));
        }
        catch (Exception ex) {
            throw new CMException(1102, (Throwable)ex);
        }
    }

    public BasicServerRequest(URL url) throws CMException {
        super(0, null);
        try {
            this.commonConstruct(url);
        }
        catch (Exception ex) {
            throw new CMException(1102, (Throwable)ex);
        }
    }

    private void commonConstruct(URL url) throws IOException {
        this.connection = (HttpURLConnection)url.openConnection();
    }

    public boolean equals(Object o) {
        if (o instanceof BasicServerRequest) {
            BasicServerRequest rhs = (BasicServerRequest)o;
            return this.contents.equals(rhs.contents);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IServerResponse execute(VMOptions options, ILogger logger) throws CMException {
        try {
            this.connection.setDoOutput(true);
            if (this.contents.size() > 0) {
                this.connection.setRequestMethod("POST");
                this.connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            } else {
                this.connection.setRequestMethod("GET");
            }
            try (OutputStream os = this.connection.getOutputStream();){
                boolean first = true;
                Enumeration keyEnum = this.contents.keys();
                while (keyEnum.hasMoreElements()) {
                    String key = (String)keyEnum.nextElement();
                    String value = (String)this.contents.get(key);
                    if (first) {
                        first = false;
                    } else {
                        os.write(38);
                    }
                    os.write(key.getBytes("UTF-8"));
                    os.write(61);
                    os.write(value.getBytes("UTF-8"));
                }
            }
            this.connection.connect();
            return new BasicServerResponse(this.connection);
        }
        catch (Exception ex) {
            VM.log(CLASS, 3, ex);
            throw new CMException(1102, (Throwable)ex);
        }
    }

    @Override
    public IServerRequest copy() throws CMException {
        return this.copy(URI.parseURI(this.connection.getURL().toExternalForm(), false), 3);
    }

    @Override
    public IServerRequest copy(URI uri, int flags) throws CMException {
        BasicServerRequest copy = new BasicServerRequest(uri.toString());
        if ((flags & 2) != 0) {
            Enumeration keyEnum = this.contents.keys();
            while (keyEnum.hasMoreElements()) {
                String key = (String)keyEnum.nextElement();
                String value = (String)this.contents.get(key);
                copy.contents.put(key, value);
            }
        }
        return copy;
    }

    public void setHttpBasicAuthentication(String credentials) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] bytes = credentials.getBytes();
        try {
            Base64.encode((byte[])bytes, (int)0, (int)bytes.length, (OutputStream)bos);
            bos.close();
            String headerValue = "Basic " + bos.toString();
            this.connection.setRequestProperty("Authorization", headerValue);
            VM.log(CLASS, 0, "sending credentials: " + headerValue);
        }
        catch (IOException ex) {
            VM.log(CLASS, 3, "failed to set credentials", ex);
        }
    }

    @Override
    public void cancel() {
        HttpURLConnection uc = this.connection;
        if (uc != null) {
            uc.disconnect();
        }
    }

    @Override
    protected IServerRequest create(int requestType, URI uri) throws CMException {
        return new BasicServerRequest("");
    }
}

