/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.request.se;

import com.cognos.mobile.common.ByteArrayHelper;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.request.IServerResponse;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.ArrayList;

public class BasicServerResponse
extends IServerResponse {
    private final HttpURLConnection connection;
    private final String[] cookies;
    private int contentLength = -1;
    private InputStream responseInputStream = null;
    private int peekLength;

    public BasicServerResponse(HttpURLConnection connection) throws CMException {
        String headerName;
        this.connection = connection;
        ArrayList<String> setCookies = new ArrayList<String>();
        int i = 1;
        while ((headerName = connection.getHeaderFieldKey(i)) != null) {
            if (headerName.equalsIgnoreCase("set-cookie")) {
                setCookies.add(connection.getHeaderField(i));
            } else if (headerName.equalsIgnoreCase("content-length")) {
                try {
                    this.contentLength = Integer.parseInt(connection.getHeaderField(i));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ++i;
        }
        this.cookies = new String[setCookies.size()];
        setCookies.toArray(this.cookies);
        super.findAndStoreCAMCookie(this.cookies);
    }

    @Override
    public String getHeader(String header) {
        return this.connection.getHeaderField(header);
    }

    @Override
    public String getAuthenticationDomain() {
        return null;
    }

    @Override
    public String getContentType() throws CMException {
        return this.connection.getContentType();
    }

    @Override
    public String[] getCookies() {
        return this.cookies;
    }

    @Override
    public boolean responseBodyContains(String target) throws CMException {
        try {
            this._ensureInputStreamIsPopulatedAndReset();
            byte[] peek = new byte[this.peekLength];
            this.responseInputStream.read(peek, 0, this.peekLength);
            return ByteArrayHelper.indexOf(peek, target.getBytes()) != -1;
        }
        catch (Exception ex) {
            throw new CMException(1102, (Throwable)ex);
        }
    }

    @Override
    public InputStream getInputStream() throws CMException {
        try {
            this._ensureInputStreamIsPopulatedAndReset();
            return this.responseInputStream;
        }
        catch (Exception ex) {
            throw new CMException(1102, (Throwable)ex);
        }
    }

    @Override
    public int getResponseCode() throws CMException {
        try {
            return this.connection.getResponseCode();
        }
        catch (Exception ex) {
            throw new CMException(1102, (Throwable)ex);
        }
    }

    @Override
    public int getContentLength() throws CMException {
        return this.contentLength;
    }

    @Override
    public void close() {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    private void _ensureInputStreamIsPopulatedAndReset() throws Exception {
        if (this.responseInputStream == null) {
            this.peekLength = this.contentLength == -1 ? IServerResponse.NUMBER_OF_BYTES_TO_PEEK_IN_RESPONSE : Math.min(this.contentLength, IServerResponse.NUMBER_OF_BYTES_TO_PEEK_IN_RESPONSE);
            this.responseInputStream = new BufferedInputStream(this.connection.getInputStream(), this.peekLength);
            this.responseInputStream.mark(this.peekLength);
        } else {
            this.responseInputStream.reset();
        }
    }
}

