/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.request.se;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMUrlHelper;
import com.cognos.mobile.common.ILogger;
import com.cognos.mobile.request.IServerRequest;
import com.cognos.mobile.request.IServerRequestFactory;
import com.cognos.mobile.request.IServerResponse;
import com.cognos.mobile.request.URI;
import com.cognos.mobile.request.se.BasicServerRequest;
import com.cognos.mobile.request.se.ServerResponse;
import com.cognos.mobile.standardedition.SEGetMethod;
import com.cognos.mobile.standardedition.SEPostMethod;
import com.cognos.mobile.task.ICancellable;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMOptions;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;

public final class ServerRequest
extends IServerRequest {
    private static final Class CLASS = ServerRequest.class;
    private BasicServerRequest bsr;
    private volatile ICancellable cancellableObject = ICancellable.NULL;

    public ServerRequest(int requestType, URI uri) {
        super(requestType, uri);
    }

    private static HttpClient getHttpClient() {
        String proxyHost = null;
        int proxyPort = -1;
        try {
            proxyHost = System.getProperty("http.proxyHost");
            proxyPort = Integer.parseInt(System.getProperty("http.proxyPort", "-1"));
        }
        catch (Exception t) {
            VM.log(CLASS, 0, "Cannot read System Properties to configure proxy host for httpclient.");
        }
        HttpClient hc = new HttpClient();
        if (proxyHost != null && proxyPort > 0) {
            hc.getHostConfiguration().setProxy(proxyHost, proxyPort);
        }
        return hc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IServerResponse execute(VMOptions options, ILogger logger) throws CMException {
        ICancellable m;
        String value;
        String fullUrl = this.uri.toString();
        if (this.contents.size() > 0) {
            if (this.requestType == IServerRequestFactory.REQUEST_TYPE_GET) {
                SEGetMethod gm;
                int delim = 63;
                if (fullUrl.indexOf(63) > 0) {
                    delim = 38;
                }
                for (String key : this.contents.keySet()) {
                    value = (String)this.contents.get(key);
                    fullUrl = fullUrl + (char)delim + key + "=" + value;
                    delim = 38;
                }
                VM.log(CLASS, 0, "getting " + fullUrl);
                m = gm = new SEGetMethod(fullUrl);
                this.cancellableObject = gm;
            } else {
                VM.log(CLASS, 0, "posting to " + fullUrl);
                SEPostMethod pm = new SEPostMethod(fullUrl);
                pm.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                m = pm;
                this.cancellableObject = pm;
                for (String key : this.contents.keySet()) {
                    value = (String)this.contents.get(key);
                    ((PostMethod)m).addParameter(key, CMUrlHelper.decodeUrl(value));
                }
            }
        } else {
            SEGetMethod gm;
            VM.log(CLASS, 0, "getting from " + fullUrl);
            m = gm = new SEGetMethod(fullUrl);
            this.cancellableObject = gm;
        }
        for (String key : this.headers.keySet()) {
            String value2 = (String)this.headers.get(key);
            m.addRequestHeader(key, value2);
        }
        HttpClient hc = ServerRequest.getHttpClient();
        m.setFollowRedirects(false);
        hc.executeMethod((HttpMethod)m);
        this.cancellableObject = ICancellable.NULL;
        if (m.getStatusCode() != 401 || m.getResponseHeader("WWW-AUTHENTICATE").getValue().indexOf("NTLM") <= 0) return new ServerResponse((HttpMethod)m);
        m.releaseConnection();
        this.bsr = new BasicServerRequest(fullUrl);
        this.cancellableObject = this.bsr;
        for (String key : this.headers.keySet()) {
            value = (String)this.headers.get(key);
            this.bsr.setHeader(key, value);
        }
        for (String key : this.contents.keySet()) {
            value = (String)this.contents.get(key);
            this.bsr.setArgument(key, value);
        }
        try {
            IServerResponse iServerResponse = this.bsr.execute(options, logger);
            this.cancellableObject = ICancellable.NULL;
            return iServerResponse;
        }
        catch (Throwable throwable) {
            try {
                this.cancellableObject = ICancellable.NULL;
                throw throwable;
            }
            catch (Exception ex) {
                VM.log(CLASS, 3, ex);
                throw new CMException(1102, (Throwable)ex);
            }
        }
    }

    @Override
    public IServerRequest copy() throws CMException {
        if (this.bsr != null) {
            return this.bsr.copy();
        }
        return super.copy();
    }

    @Override
    public void cancel() {
        this.cancellableObject.cancel();
    }

    @Override
    protected IServerRequest create(int requestType, URI uri) {
        return new ServerRequest(requestType, uri);
    }
}

