/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.request.se;

import com.cognos.mobile.common.ByteArrayHelper;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.request.IServerResponse;
import com.cognos.mobile.standardedition.HttpClientInputStream;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;

public class ServerResponse
extends IServerResponse {
    private final String[] cookies;
    private final HttpMethod m;
    private int contentLength = -1;
    private String contentType;
    private InputStream responseInputStream = null;
    private int peekLength;

    public ServerResponse(HttpMethod m) throws CMException {
        this.m = m;
        ArrayList<String> setCookies = new ArrayList<String>();
        Header[] h = m.getResponseHeaders();
        for (int i = 0; i < h.length; ++i) {
            String headerName = h[i].getName();
            if (headerName.equalsIgnoreCase("content-type")) {
                this.contentType = h[i].getValue();
                continue;
            }
            if (headerName.equalsIgnoreCase("set-cookie")) {
                setCookies.add(h[i].getValue());
                continue;
            }
            if (!headerName.equalsIgnoreCase("content-length")) continue;
            try {
                this.contentLength = Integer.parseInt(h[i].getValue());
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.cookies = new String[setCookies.size()];
        setCookies.toArray(this.cookies);
        super.findAndStoreCAMCookie(this.cookies);
    }

    @Override
    public String getHeader(String header) {
        Header h = this.m.getResponseHeader(header);
        return h == null ? null : h.getValue();
    }

    @Override
    public String getAuthenticationDomain() {
        return null;
    }

    @Override
    public String getContentType() throws CMException {
        return this.contentType;
    }

    @Override
    public String[] getCookies() {
        return this.cookies;
    }

    @Override
    public boolean responseBodyContains(String target) throws CMException {
        try {
            this._ensureInputStreamIsPopulatedAndReset();
            byte[] peek = new byte[this.peekLength];
            this.responseInputStream.read(peek, 0, this.peekLength);
            return ByteArrayHelper.indexOf(peek, target.getBytes()) != -1;
        }
        catch (Exception ex) {
            throw new CMException(1102, (Throwable)ex);
        }
    }

    @Override
    public InputStream getInputStream() throws CMException {
        try {
            this._ensureInputStreamIsPopulatedAndReset();
            return this.responseInputStream;
        }
        catch (Exception ex) {
            throw new CMException(1102, (Throwable)ex);
        }
    }

    @Override
    public int getResponseCode() throws CMException {
        try {
            return this.m.getStatusCode();
        }
        catch (Exception ex) {
            throw new CMException(1102, (Throwable)ex);
        }
    }

    @Override
    public int getContentLength() throws CMException {
        return this.contentLength;
    }

    @Override
    public void close() throws CMException {
        try {
            if (this.m != null) {
                this.m.releaseConnection();
            }
            if (this.responseInputStream != null) {
                this.responseInputStream.close();
            }
        }
        catch (Exception e) {
            throw new CMException(1102, (Throwable)e);
        }
    }

    private void _ensureInputStreamIsPopulatedAndReset() throws Exception {
        if (this.responseInputStream == null) {
            this.peekLength = this.contentLength == -1 ? IServerResponse.NUMBER_OF_BYTES_TO_PEEK_IN_RESPONSE : Math.min(this.contentLength, IServerResponse.NUMBER_OF_BYTES_TO_PEEK_IN_RESPONSE);
            this.responseInputStream = new BufferedInputStream(new HttpClientInputStream(this.m), this.peekLength);
            this.responseInputStream.mark(this.peekLength);
        } else {
            this.responseInputStream.reset();
        }
    }
}

