/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.server.core;

import java.util.concurrent.ConcurrentHashMap;

public class RenderWatcher {
    static ConcurrentHashMap<Integer, RenderWatcher> renderWatchers = new ConcurrentHashMap();
    private boolean isComplete;
    private int renderID;

    private RenderWatcher(int renderID) {
        this.renderID = renderID;
    }

    public static RenderWatcher construct(int renderID) {
        RenderWatcher watcher = new RenderWatcher(renderID);
        renderWatchers.put(renderID, watcher);
        return watcher;
    }

    public static void discard(RenderWatcher watcher) {
        renderWatchers.remove(watcher.renderID);
    }

    public static boolean isRenderComplete(int renderID, int waitForSeconds) {
        boolean isRenderComplete = false;
        RenderWatcher watcher = renderWatchers.get(renderID);
        isRenderComplete = watcher == null ? true : (waitForSeconds > 0 ? watcher.waitForCompletion(waitForSeconds) : watcher.isComplete);
        return isRenderComplete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForCompletion(int timeLimitSecs) {
        RenderWatcher renderWatcher = this;
        synchronized (renderWatcher) {
            if (this.isComplete) {
                return true;
            }
            try {
                this.wait(timeLimitSecs * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.isComplete;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAvailable() {
        RenderWatcher renderWatcher = this;
        synchronized (renderWatcher) {
            this.isComplete = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrompting() {
        RenderWatcher renderWatcher = this;
        synchronized (renderWatcher) {
            this.isComplete = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setComplete() {
        RenderWatcher renderWatcher = this;
        synchronized (renderWatcher) {
            this.isComplete = true;
            this.notifyAll();
        }
    }
}

