/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.server.tabs;

import com.cognos.mobile.database.RenderRow;
import com.cognos.mobile.server.tabs.TabInfoList;
import com.cognos.mobile.vm.VM;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.OrderedJSONObject;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.dom4j.DocumentException;

public class TabInfoHelper {
    private static String TABS_FIELD = "t";
    private static String ID_HASH_FIELD = "i";
    private static String PAGE_COUNT_FIELD = "p";
    private static String HAS_NEXT_PAGE_FIELD = "h";

    public static String getTabInfoAsJson(TabInfoList tabInfoList) throws XMLStreamException, IOException, DocumentException {
        String returnValue = null;
        if (tabInfoList != null && tabInfoList.size() > 0) {
            StringBuilder builder = new StringBuilder();
            builder.append("{\"").append(TABS_FIELD).append("\":[");
            for (TabInfoList.TabInfo tab : tabInfoList) {
                builder.append("{\"").append(ID_HASH_FIELD).append("\":\"");
                builder.append(tab.idHash);
                builder.append("\",\"").append(PAGE_COUNT_FIELD).append("\":");
                builder.append(tab.pageCount);
                builder.append(",\"").append(HAS_NEXT_PAGE_FIELD).append("\":");
                builder.append(String.valueOf(tab.hasMorePages));
                builder.append("}");
                if (tabInfoList.indexOf(tab) == tabInfoList.size() - 1) continue;
                builder.append(",");
            }
            builder.append("]}");
            returnValue = builder.toString();
        }
        return returnValue;
    }

    public static TabInfoList generateTabInfoList(String jsonTabInfo) {
        TabInfoList returnValue;
        block10: {
            returnValue = null;
            try {
                if (jsonTabInfo == null || jsonTabInfo.length() <= 0) break block10;
                OrderedJSONObject objTabInfo = (OrderedJSONObject)JSON.parse((String)jsonTabInfo, (boolean)true);
                JSONArray tabs = (JSONArray)objTabInfo.get((Object)TABS_FIELD);
                returnValue = new TabInfoList(tabs.size());
                for (Object tab : tabs) {
                    OrderedJSONObject tabObj = (OrderedJSONObject)tab;
                    if (tabObj == null) continue;
                    TabInfoList.TabInfo tabInfo = new TabInfoList.TabInfo();
                    String tabIdHash = (String)tabObj.get((Object)ID_HASH_FIELD);
                    if (tabIdHash != null && tabIdHash.length() > 0) {
                        tabInfo.idHash = tabIdHash;
                    }
                    try {
                        Long pageCount = (Long)tabObj.get((Object)PAGE_COUNT_FIELD);
                        if (pageCount != null) {
                            tabInfo.pageCount = (int)pageCount.longValue();
                        }
                    }
                    catch (ClassCastException e) {
                        throw new ClassCastException("encountered invalid pageCount in tab: " + tabObj.serialize() + " = " + e.getMessage());
                    }
                    try {
                        Boolean hasMorePages = (Boolean)tabObj.get((Object)HAS_NEXT_PAGE_FIELD);
                        if (hasMorePages != null) {
                            tabInfo.hasMorePages = hasMorePages;
                        }
                    }
                    catch (ClassCastException e) {
                        throw new ClassCastException("encountered invalid hasMorePages in tab: " + tabObj.serialize() + " = " + e.getMessage());
                    }
                    returnValue.add(tabInfo);
                }
            }
            catch (Throwable e) {
                VM.log(RenderRow.class, 2, "failed to parse tab info: " + e.getMessage());
            }
        }
        return returnValue;
    }
}

