/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.server.tabs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class TabInfoList
implements List<TabInfo> {
    private ArrayList<TabInfo> tabInfoList;

    public TabInfoList() {
        this.tabInfoList = new ArrayList();
    }

    public TabInfoList(int size) {
        this.tabInfoList = new ArrayList(size);
    }

    public TabInfo getTabInfo(String idHash) {
        if (idHash == null) {
            return null;
        }
        for (TabInfo tabInfo : this.tabInfoList) {
            if (!idHash.equals(tabInfo.idHash)) continue;
            return tabInfo;
        }
        return null;
    }

    public void addTabInfo(TabInfo tabInfo) {
        if (tabInfo != null) {
            for (TabInfo currentTabInfo : this.tabInfoList) {
                if (!tabInfo.idHash.equals(currentTabInfo.idHash)) continue;
                this.tabInfoList.set(this.tabInfoList.indexOf(currentTabInfo), tabInfo);
                return;
            }
            this.tabInfoList.add(tabInfo);
        }
    }

    public int pageCount() {
        int pageCount = 0;
        for (TabInfo tabInfo : this.tabInfoList) {
            if (tabInfo.pageCount <= -1) continue;
            pageCount += tabInfo.pageCount;
        }
        return pageCount;
    }

    @Override
    public int size() {
        return this.tabInfoList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.tabInfoList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.tabInfoList.contains(o);
    }

    @Override
    public Iterator<TabInfo> iterator() {
        return this.tabInfoList.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.tabInfoList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.tabInfoList.toArray(a);
    }

    @Override
    public boolean add(TabInfo e) {
        return this.tabInfoList.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.tabInfoList.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.tabInfoList.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends TabInfo> c) {
        return this.tabInfoList.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends TabInfo> c) {
        return this.tabInfoList.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.tabInfoList.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.tabInfoList.retainAll(c);
    }

    @Override
    public void clear() {
        this.tabInfoList.clear();
    }

    @Override
    public TabInfo get(int index) {
        return this.tabInfoList.get(index);
    }

    @Override
    public TabInfo set(int index, TabInfo element) {
        return this.tabInfoList.set(index, element);
    }

    @Override
    public void add(int index, TabInfo element) {
        this.tabInfoList.add(index, element);
    }

    @Override
    public TabInfo remove(int index) {
        return this.tabInfoList.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.tabInfoList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.tabInfoList.lastIndexOf(o);
    }

    @Override
    public ListIterator<TabInfo> listIterator() {
        return this.tabInfoList.listIterator();
    }

    @Override
    public ListIterator<TabInfo> listIterator(int index) {
        return this.tabInfoList.listIterator(index);
    }

    @Override
    public List<TabInfo> subList(int fromIndex, int toIndex) {
        return this.tabInfoList.subList(fromIndex, toIndex);
    }

    public static class TabInfo {
        public String idHash;
        public int pageCount;
        public boolean hasMorePages;

        public TabInfo() {
            this.idHash = null;
            this.pageCount = -1;
            this.hasMorePages = false;
        }

        public TabInfo(String idHash) {
            this.idHash = idHash;
            this.pageCount = -1;
            this.hasMorePages = false;
        }

        public TabInfo(String idHash, int pageCount, boolean hasMorePages) {
            this.idHash = idHash;
            this.pageCount = pageCount;
            this.hasMorePages = hasMorePages;
        }

        public boolean tabInfoEquals(TabInfo other) {
            if (!this.idHash.equals(other.idHash)) {
                return false;
            }
            if (this.pageCount != other.pageCount) {
                return false;
            }
            return this.hasMorePages == other.hasMorePages;
        }
    }
}

