/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.standardedition;

import com.cognos.mobile.vm.VM;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.DOMReader;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.dom4j.Dom4jXPath;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class DOM4JUtil {
    private static final Class CLASS = DOM4JUtil.class;
    public static final SimpleNamespaceContext CCS_NAMESPACE_CONTEXT = new SimpleNamespaceContext();
    public static final String XHTMLDOCTYPE = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">";
    public static final String XHTMLNS = "<html xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:svg=\"http://www.w3.org/2000/svg\" >";
    private static final Pattern doctypeP;
    private static final Pattern htmlP;
    public static final DocumentFactory df;

    public static Element read(URL u) throws IOException, DocumentException {
        URLConnection juc = u.openConnection();
        SAXReader xmlReader = new SAXReader();
        Document doc = xmlReader.read((InputStream)juc.getContent());
        Element root = doc.getRootElement();
        root.detach();
        return root;
    }

    public static Document readDocumentFromXHTML(String in) throws IOException, DocumentException {
        Matcher m = doctypeP.matcher(in);
        if (m.find()) {
            in = m.replaceFirst("");
        }
        if ((m = htmlP.matcher(in)).find()) {
            in = m.replaceFirst("<html>");
        }
        return DocumentHelper.parseText((String)in);
    }

    public static XPath createXPathForHTML(String path) {
        XPath xpath = DocumentHelper.createXPath((String)path);
        SimpleNamespaceContext nc = new SimpleNamespaceContext();
        nc.addNamespace("html", "http://www.w3.org/1999/xhtml");
        xpath.setNamespaceContext((NamespaceContext)nc);
        return xpath;
    }

    public static void insert(List nodes, Element destination) {
        for (Element element : nodes) {
            element.detach();
            destination.add(element);
        }
    }

    public static void addAttributes(Element source, Element destination) {
        if (source != null) {
            List atts = source.attributes();
            for (Attribute att : atts) {
                att.detach();
                destination.add(att);
            }
        }
    }

    public static Element createElement(String tag, Map attributes) {
        Element el = df.createElement(tag);
        Set k = attributes.keySet();
        for (String key : k) {
            String value = (String)attributes.get(key);
            DOM4JUtil.addAttribute(el, key, value);
        }
        return el;
    }

    public static Element mergeXHTML(Element reportDoc, Element viewerDoc) {
        Node title;
        Element outputDoc = df.createElement("html");
        Element outputHeadEl = df.createElement("head");
        Element outputBodyEl = df.createElement("body");
        Node viewerBodyEl = viewerDoc.selectSingleNode("body");
        Node reportBodyEl = reportDoc.selectSingleNode("body");
        DOM4JUtil.addAttributes((Element)viewerBodyEl, outputBodyEl);
        DOM4JUtil.addAttributes((Element)reportBodyEl, outputBodyEl);
        outputDoc.add(outputHeadEl);
        outputDoc.add(outputBodyEl);
        Node viewerHeadEl = viewerDoc.selectSingleNode("head");
        Node reportHeadEl = reportDoc.selectSingleNode("head");
        if (reportHeadEl != null && (title = reportHeadEl.selectSingleNode("title")) != null) {
            title.detach();
            outputDoc.add(title);
        }
        if (reportHeadEl != null) {
            DOM4JUtil.insert(reportHeadEl.selectNodes("meta"), outputHeadEl);
        }
        if (viewerHeadEl != null) {
            DOM4JUtil.insert(viewerHeadEl.selectNodes("meta"), outputHeadEl);
        }
        if (reportHeadEl != null) {
            DOM4JUtil.insert(reportHeadEl.selectNodes("style"), outputHeadEl);
        }
        if (viewerHeadEl != null) {
            DOM4JUtil.insert(viewerHeadEl.selectNodes("style"), outputHeadEl);
        }
        if (reportHeadEl != null) {
            DOM4JUtil.insert(reportHeadEl.selectNodes("link"), outputHeadEl);
        }
        if (viewerHeadEl != null) {
            DOM4JUtil.insert(viewerHeadEl.selectNodes("link"), outputHeadEl);
        }
        if (reportHeadEl != null) {
            DOM4JUtil.insert(reportHeadEl.selectNodes("script"), outputHeadEl);
        }
        if (viewerHeadEl != null) {
            DOM4JUtil.insert(viewerHeadEl.selectNodes("script"), outputHeadEl);
        }
        DOM4JUtil.insert(((Element)reportDoc.selectSingleNode("body")).elements(), outputBodyEl);
        DOM4JUtil.insert(((Element)viewerDoc.selectSingleNode("body")).elements(), outputBodyEl);
        return outputDoc;
    }

    public static Element read(String sin) throws IOException, DocumentException {
        Document doc = DocumentHelper.parseText((String)sin);
        Element root = doc.getRootElement();
        root.detach();
        return root;
    }

    public static Element readAndResolveEntity(String sin) throws IOException, DocumentException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        db.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new StringReader(systemId));
            }
        });
        InputSource is = new InputSource(new StringReader(sin));
        org.w3c.dom.Document domDocument = db.parse(is);
        Document doc = new DOMReader().read(domDocument);
        Element root = doc.getRootElement();
        root.detach();
        return root;
    }

    public static Element read(InputStream in) throws IOException, DocumentException {
        SAXReader xmlReader = new SAXReader();
        Document doc = xmlReader.read(in);
        Element root = doc.getRootElement();
        root.detach();
        return root;
    }

    public static Element read(InputStream in, boolean ignoreNamespaces) throws IOException, DocumentException {
        if (!ignoreNamespaces) {
            return DOM4JUtil.read(in);
        }
        final Namespace blankNS = new Namespace("", "");
        SAXReader xmlReader = new SAXReader(new DocumentFactory(){

            public Namespace createNamespace(String prefix, String uri) {
                return blankNS;
            }
        }, false);
        Document doc = xmlReader.read(in);
        Element root = doc.getRootElement();
        root.detach();
        return root;
    }

    public static String prettyPrint(InputStream in) throws IOException, DocumentException {
        return DOM4JUtil.prettyPrint(DOM4JUtil.read(in));
    }

    private static OutputFormat createPrettyOutputFormat() {
        OutputFormat outformat = OutputFormat.createPrettyPrint();
        outformat.setTrimText(false);
        outformat.setEncoding("UTF-8");
        return outformat;
    }

    private static OutputFormat createCompactOutputFormat() {
        OutputFormat outformat = OutputFormat.createCompactFormat();
        outformat.setIndent(false);
        outformat.setNewlines(false);
        outformat.setExpandEmptyElements(false);
        outformat.setSuppressDeclaration(true);
        outformat.setTrimText(false);
        outformat.setEncoding("UTF-8");
        return outformat;
    }

    private static OutputFormat createHTMLFriendlyOutputFormat() {
        OutputFormat outformat = OutputFormat.createPrettyPrint();
        outformat.setTrimText(false);
        outformat.setExpandEmptyElements(true);
        outformat.setPadText(true);
        outformat.setEncoding("UTF-8");
        return outformat;
    }

    public static String prettyPrint(Document node) throws IOException {
        StringWriter out = new StringWriter();
        XMLWriter writer = new XMLWriter((Writer)out, DOM4JUtil.createPrettyOutputFormat());
        writer.write(node);
        writer.flush();
        return out.toString();
    }

    public static String prettyPrintAsXHTML(Element node) throws IOException {
        StringWriter out = new StringWriter();
        XMLWriter writer = new XMLWriter((Writer)out, DOM4JUtil.createHTMLFriendlyOutputFormat());
        writer.write(node);
        writer.flush();
        String result = out.toString();
        result = result.replaceFirst("<html>", XHTMLNS);
        result = XHTMLDOCTYPE + result;
        return result;
    }

    public static void addAttribute(Element el, String name, String value) {
        if (value != null) {
            el.add(df.createAttribute(el, name, value));
        }
    }

    public static void addAttribute(Element el, Map m) {
        for (String key : m.keySet()) {
            String value = (String)m.get(key);
            el.add(df.createAttribute(el, key, value));
        }
    }

    public static void addAttribute(Element el, String name, String[] value, String delim) {
        if (value != null && value.length > 0) {
            StringBuffer sb = new StringBuffer();
            Iterator<String> sit = Arrays.asList(value).iterator();
            while (sit.hasNext()) {
                sb.append(sit.next() + (sit.hasNext() ? delim : ""));
            }
            el.add(df.createAttribute(el, name, sb.toString()));
        }
    }

    public static String prettyPrint(String node) {
        try {
            Element el = DOM4JUtil.readAndResolveEntity(node);
            return DOM4JUtil.prettyPrint(el);
        }
        catch (Exception e) {
            VM.log(CLASS, 3, "Problem prettyPrinting:\n" + node + "\n");
            return node;
        }
    }

    public static String compactPrint(Element el, boolean stripNamespaces) {
        if (!stripNamespaces) {
            return DOM4JUtil.compactPrint(el);
        }
        StringWriter out = new StringWriter();
        try {
            XMLWriter writer = new XMLWriter(out, DOM4JUtil.createPrettyOutputFormat()){

                protected void writeAttributes(Element element) throws IOException {
                    super.writeAttributes(element);
                }

                protected void writeElement(Element element) throws IOException {
                    Element e = element.createCopy(element.getName());
                    List dns = e.declaredNamespaces();
                    for (Namespace ns : dns) {
                        e.remove(ns);
                    }
                    super.writeElement(e);
                }
            };
            writer.write(el);
            writer.flush();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return out.toString();
    }

    public static String compactPrint(String node) {
        try {
            Element el = DOM4JUtil.read(node);
            return DOM4JUtil.compactPrint(el);
        }
        catch (Exception e) {
            VM.log(CLASS, 3, "Problem compactPrinting:\n" + node + "\n", e);
            return node;
        }
    }

    public static Node findInElement(String xpath, Element element) {
        element.detach();
        Document d = df.createDocument(element);
        return d.selectSingleNode(xpath);
    }

    public static Node findInElement(String xpath, Element element, String prefix) {
        element.detach();
        Document d = df.createDocument(element);
        Node node = null;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(prefix, element.getNamespaceURI());
        try {
            Dom4jXPath d4jxp = new Dom4jXPath(xpath);
            d4jxp.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(map));
            node = (Node)d4jxp.selectSingleNode((Object)d);
        }
        catch (JaxenException e) {
            VM.log(CLASS, 3, "Problem findInElement:\nXPath = " + xpath + "\n", e);
        }
        return node;
    }

    public static String prettyPrint(Element node) {
        try {
            StringWriter out = new StringWriter();
            XMLWriter writer = new XMLWriter((Writer)out, DOM4JUtil.createPrettyOutputFormat());
            writer.write(node);
            writer.flush();
            return out.toString();
        }
        catch (IOException ioe) {
            VM.log(CLASS, 3, "Problem prettyPrinting:\n" + node.asXML() + "\n", ioe);
            return node.asXML();
        }
    }

    public static String compactPrint(Element node) {
        try {
            StringWriter out = new StringWriter();
            XMLWriter writer = new XMLWriter((Writer)out, DOM4JUtil.createCompactOutputFormat());
            writer.write(node);
            writer.flush();
            return out.toString();
        }
        catch (IOException ioe) {
            VM.log(CLASS, 3, "Problem compactPrinting:\n" + node.asXML() + "\n", ioe);
            return node.asXML();
        }
    }

    public static void main(String[] args) throws Exception {
        String xml = "<document><page><id>Page1</id><body><item><widget><id>MultiSheetCascade1</id><style>DS1</style><type>viewer</type><widgetURI>http://localhost:9200/p2pd/servlet/dispatch/rds/reportPrompts/report/i0d0139dd41f848f7be9eb2c0cbc57b2f</widgetURI><storeID>i0d0139dd41f848f7be9eb2c0cbc57b2f</storeID></widget></item><item><widget><id>SingleSheetCascade1</id><style>DS2</style><type>viewer</type><widgetURI>http://localhost:9200/p2pd/servlet/dispatch/rds/reportPrompts/report/icd58922dc6f74155971717728f578a0e</widgetURI><storeID>icd58922dc6f74155971717728f578a0e</storeID></widget></item></body></page><styleGroup><name>DS1</name><boxStyle><height><val>213</val><units>PX</units></height><width><val>333</val><units>PX</units></width><x><val>438</val><units>PX</units></x><y><val>290</val><units>PX</units></y><drawOrder>102</drawOrder><position>absolute</position></boxStyle></styleGroup><styleGroup><name>DS2</name><boxStyle><height><val>863</val><units>PX</units></height><width><val>343</val><units>PX</units></width><x><val>438</val><units>PX</units></x><y><val>614</val><units>PX</units></y><drawOrder>104</drawOrder><position>absolute</position></boxStyle></styleGroup></document>";
    }

    static {
        CCS_NAMESPACE_CONTEXT.addNamespace("rds", "http://developer.cognos.com/schemas/rds/types/2");
        doctypeP = Pattern.compile("(<!DOCTYPE .*?>)");
        htmlP = Pattern.compile("(<html .*?>)");
        df = DocumentFactory.getInstance();
    }
}

