/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.standardedition;

import com.cognos.mobile.common.CMException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Vector;

public class FileHelper {
    public static void copyFiles(String from, String to, PrintStream out) throws CMException {
        String[] fromChildren;
        File fromDir = new File(from);
        File toDir = new File(to);
        if (!toDir.exists() && !toDir.mkdir()) {
            throw new CMException(1000, "failed to create directory: " + to);
        }
        if (fromDir.isFile()) {
            FileHelper.copyFileToDir(from, to, out);
        } else if (fromDir.isDirectory() && (fromChildren = fromDir.list()) != null && fromChildren.length != 0) {
            for (int i = 0; i < fromChildren.length; ++i) {
                File fromChild = new File(from + '/' + fromChildren[i]);
                if (fromChild.isFile()) {
                    FileHelper.copyFileToDir(fromChild.getPath(), to, out);
                    continue;
                }
                if (!fromChild.isDirectory()) continue;
                FileHelper.copyFiles(fromChild.getPath(), to + '/' + fromChild.getName(), out);
            }
        }
    }

    public static void copyFileToDir(String from, String to, PrintStream out) throws CMException {
        File fromFile = new File(from);
        FileHelper.copyFileToFile(from, to + '/' + fromFile.getName(), out);
    }

    public static void copyFileToFile(String from, String to, PrintStream out) throws CMException {
        File fromFile = new File(from);
        File toFile = new File(to);
        FileInputStream fromStream = null;
        FileOutputStream toStream = null;
        if (out != null) {
            out.println("- " + toFile.getPath());
        }
        try {
            int bytesRead;
            if (toFile.exists()) {
                toFile.delete();
            }
            toFile.createNewFile();
            fromStream = new FileInputStream(fromFile);
            toStream = new FileOutputStream(toFile);
            byte[] chunk = new byte[4096];
            while ((bytesRead = fromStream.read(chunk)) != -1) {
                toStream.write(chunk, 0, bytesRead);
            }
        }
        catch (IOException ex) {
            throw new CMException(1000, "failed to copy '" + from + "' to directory '" + to + "'", (Throwable)ex);
        }
        finally {
            try {
                if (fromStream != null) {
                    fromStream.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (toStream != null) {
                    toStream.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void deleteFiles(String f) throws CMException {
        File file = new File(f);
        if (file.isFile()) {
            if (!file.delete()) {
                throw new CMException(1000, "failed to delete file: " + f);
            }
        } else if (file.isDirectory()) {
            String[] children = file.list();
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    FileHelper.deleteFiles(f + '/' + children[i]);
                }
            }
            if (!file.delete()) {
                throw new CMException(1000, "failed to delete directory: " + f);
            }
        }
    }

    public static String[] listFiles(String from) throws CMException {
        Vector list = new Vector();
        list = FileHelper.listFiles(from, list);
        return list.toArray(new String[0]);
    }

    public static void makeDir(String dirPath) throws CMException {
        File dir = new File(dirPath);
        if (!dir.exists()) {
            boolean created = false;
            try {
                created = dir.mkdirs();
            }
            catch (SecurityException ex) {
                created = false;
            }
            if (!created) {
                throw new CMException(1000, "failed to create directory: " + dirPath);
            }
        }
    }

    public static void replaceContent(File file, byte[] b) throws IOException {
        file.delete();
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            ((OutputStream)fout).write(b);
        }
        finally {
            if (fout != null) {
                fout.flush();
                ((OutputStream)fout).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] slurp(File file) throws IOException {
        if (file.length() <= 0L || file.length() > 10000000L) {
            throw new IllegalArgumentException("bad file size for: " + file.getPath());
        }
        byte[] b = new byte[(int)file.length()];
        try (FileInputStream fin = null;){
            fin = new FileInputStream(file);
            int size = ((InputStream)fin).read(b);
            if ((long)size != file.length()) {
                throw new IOException("data not totally read");
            }
        }
        return b;
    }

    public static boolean fileExists(String filePath) {
        File file = new File(filePath);
        return file.isFile() && file.exists();
    }

    public static boolean dirExists(String dirPath) {
        File file = new File(dirPath);
        return file.isDirectory() && file.exists();
    }

    private static Vector listFiles(String from, Vector list) throws CMException {
        String[] fromChildren;
        File fromFile = new File(from);
        if (fromFile.isFile()) {
            list.addElement(fromFile.getPath());
        } else if (fromFile.isDirectory() && (fromChildren = fromFile.list()) != null && fromChildren.length != 0) {
            for (int i = 0; i < fromChildren.length; ++i) {
                list = FileHelper.listFiles(from + '/' + fromChildren[i], list);
            }
        }
        return list;
    }
}

