/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.standardedition;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMPathHelper;
import com.cognos.mobile.standardedition.SEPathHelper;
import com.cognos.mobile.vm.ISerializer;
import com.cognos.mobile.vm.IVMSerializable;
import com.cognos.mobile.vm.VM;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileSerializer
implements ISerializer {
    private static Class CLASS = FileSerializer.class;
    private static String SAVE_DIR_NAME = ".cognosmobile/";
    private String saveDir;

    public FileSerializer() {
        try {
            this.saveDir = CMPathHelper.ensureDir(System.getProperty("user.home"));
        }
        catch (Exception ex) {
            VM.log(CLASS, 3, "failed to read user.home: defaulting to root /");
            this.saveDir = "/";
        }
        this.saveDir = this.saveDir + SAVE_DIR_NAME;
    }

    @Override
    public void save(IVMSerializable object, String name) throws CMException {
        try {
            File file = new File(this.saveDir + name);
            SEPathHelper.ensureDirExists(this.saveDir);
            file.createNewFile();
            FileOutputStream outStream = new FileOutputStream(file);
            DataOutputStream out = new DataOutputStream(outStream);
            object.onSerializableSave(out);
            outStream.close();
        }
        catch (IOException ioe) {
            throw new CMException(2028, name, (Throwable)ioe);
        }
    }

    @Override
    public void load(IVMSerializable object, String name) throws CMException {
        try {
            File file = new File(this.saveDir + name);
            FileInputStream inStream = new FileInputStream(file);
            DataInputStream in = new DataInputStream(inStream);
            object.onSerializableLoad(in);
            inStream.close();
        }
        catch (IOException ioe) {
            throw new CMException(2028, (Throwable)ioe);
        }
    }
}

