/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.standardedition;

import com.cognos.mobile.vm.VM;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.HttpMethod;

public class HttpClientInputStream
extends InputStream {
    private static final Class CLASS = HttpClientInputStream.class;
    private final InputStream in;
    private final HttpMethod m;
    private boolean closed;

    public HttpClientInputStream(HttpMethod m) throws IOException {
        VM.log(CLASS, 0, "creating HttpClientInputStream for " + m.getURI());
        this.m = m;
        this.in = m.getResponseBodyAsStream();
    }

    public HttpMethod getHttpMethod() {
        return this.m;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.m != null) {
            this.m.releaseConnection();
        }
        if (this.in != null) {
            this.in.close();
        }
        this.closed = true;
        VM.log(CLASS, 0, "released HttpClient connection to " + this.m.getURI());
    }

    public boolean equals(Object obj) {
        return this.in.equals(obj);
    }

    public int hashCode() {
        return this.in.hashCode();
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.in.read(b);
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    public String toString() {
        return this.in.toString();
    }
}

