/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.standardedition;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.mobile.common.CMUrlHelper;
import com.cognos.mobile.common.ICookieCallback;
import com.cognos.mobile.common.IHTTPListener;
import com.cognos.mobile.common.IInputStreamFactory;
import com.cognos.mobile.standardedition.DOM4JUtil;
import com.cognos.mobile.standardedition.HttpClientInputStream;
import com.cognos.mobile.standardedition.SEGetMethod;
import com.cognos.mobile.standardedition.SEPostMethod;
import com.cognos.mobile.standardedition.StringUtil;
import com.cognos.mobile.vm.VM;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;

public class InputStreamFactory
implements IInputStreamFactory {
    private static final Class CLASS = InputStreamFactory.class;
    private static final Pattern dotdotP = Pattern.compile("/\\.\\./");
    private static final Pattern clean = Pattern.compile("^(.*?/)([^/]*?/\\.\\./)(.*?)$");
    private final CAMFactory camFactory;
    private int proxyPort;
    private String proxyHost;
    private URL m_dispatcherURL;
    private URL m_gatewayURL;
    HttpClientInputStreamFactory httpClientISF;
    private ThreadLocal httpClient = new ThreadLocal(){

        protected synchronized Object initialValue() {
            HttpClient sharedHTTPClient = null;
            if (InputStreamFactory.this.camFactory != null) {
                try {
                    sharedHTTPClient = InputStreamFactory.this.camFactory.createHttpClient();
                }
                catch (CAMCryptoException cce) {
                    throw new RuntimeException(cce.getMessage(), cce);
                }
            } else {
                sharedHTTPClient = new HttpClient();
            }
            sharedHTTPClient.setHttpConnectionManager((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
            sharedHTTPClient.getParams().setParameter("http.protocol.allow-circular-redirects", (Object)true);
            if (InputStreamFactory.this.proxyHost != null && InputStreamFactory.this.proxyPort > 0) {
                sharedHTTPClient.getHostConfiguration().setProxy(InputStreamFactory.this.proxyHost, InputStreamFactory.this.proxyPort);
            }
            return sharedHTTPClient;
        }
    };

    public InputStreamFactory(CAMFactory camFactory, String dispatcherURL, String gatewayURL) throws MalformedURLException {
        this.m_dispatcherURL = new URL(dispatcherURL);
        this.m_gatewayURL = new URL(gatewayURL);
        if (camFactory != null) {
            this.camFactory = camFactory;
            VM.log(CLASS, 0, "camFactory set");
        } else {
            this.camFactory = null;
        }
        this.httpClientISF = new HttpClientInputStreamFactory();
        try {
            this.proxyHost = System.getProperty("http.proxyHost");
            this.proxyPort = Integer.parseInt(System.getProperty("http.proxyPort", "-1"));
        }
        catch (Exception t) {
            VM.log(CLASS, 0, "Cannot read System Properties to configure proxy host for httpclient.");
        }
    }

    private static String relative2Absolute(String path) {
        if (dotdotP.matcher(path).find()) {
            Matcher m = clean.matcher(path);
            if (m.matches()) {
                return InputStreamFactory.relative2Absolute(m.group(1) + m.group(3));
            }
            return path;
        }
        return path;
    }

    @Override
    public void fetchHeaders(String url, Hashtable<String, String> cookies, IHTTPListener listener) {
        try {
            this.httpClientISF.fetchHeaders(new URL(url), cookies, listener);
        }
        catch (MalformedURLException mfe) {
            throw new RuntimeException(mfe.getMessage(), mfe);
        }
    }

    @Override
    public InputStream create(String url, String parentPath, Hashtable<String, String> cognosCookies, Hashtable formFields, ICookieCallback cookieCallback, IHTTPListener listener) throws IOException {
        if (formFields != null && formFields.size() == 0) {
            formFields = null;
        }
        Exception e = new Exception();
        e.fillInStackTrace();
        VM.log(CLASS, 0, "getting: " + url);
        URL u = new URL(url);
        if (u.getProtocol().startsWith("file:")) {
            return new FileInputStream(u.getFile());
        }
        return this.httpClientISF.create(u, parentPath, cognosCookies, formFields, cookieCallback, listener);
    }

    public static String prepareUrl(URL u) throws MalformedURLException, URIException, URISyntaxException, UnsupportedEncodingException {
        URL decodedURL = new URL(URLDecoder.decode(u.toString(), "UTF-8"));
        URI uri = new URI(decodedURL.getProtocol(), null, decodedURL.getHost(), decodedURL.getPort(), decodedURL.getPath(), decodedURL.getQuery(), decodedURL.getRef());
        return uri.toASCIIString();
    }

    @Override
    public byte[] slurp(InputStream in) throws IOException {
        return InputStreamFactory.slurpStream(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] slurpStream(InputStream in, int sizeEstimate) throws IOException {
        byte[] buff = new byte[Math.max(8192, sizeEstimate)];
        try {
            int count;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((count = in.read(buff)) > 0) {
                out.write(buff, 0, count);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static byte[] slurpStream(InputStream in) throws IOException {
        return InputStreamFactory.slurpStream(in, 0);
    }

    @Override
    public byte[] slurp(String url, String parentPath, Hashtable<String, String> cognosCookies, Hashtable formFields) throws IOException {
        int count = 0;
        try (InputStream in = null;){
            if (url.startsWith("file:")) {
                URL u = new URL(url);
                File f = new File(u.getFile());
                byte[] buff = new byte[(int)f.length()];
                in = new FileInputStream(f);
                in.read(buff);
                byte[] byArray = buff;
                return byArray;
            }
            in = this.create(url, parentPath, cognosCookies, formFields, null, null);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buff = new byte[32768];
            while ((count = in.read(buff)) > 0) {
                baos.write(buff, 0, count);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public static void logCookie(String message, String name, String value) {
        if (!VM.wouldLog(CLASS, 0)) {
            return;
        }
        if (name == null) {
            return;
        }
        if (name.equalsIgnoreCase("cam_passport")) {
            VM.log(CLASS, 0, message + " - cookie: " + name + " = " + StringUtil.maskPassport(value));
            return;
        }
        VM.log(CLASS, 0, message + " - cookie: " + name + " = " + value);
    }

    public static byte[] form2bytes(Hashtable formFields) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        boolean first = true;
        Enumeration keyEnum = formFields.keys();
        while (keyEnum.hasMoreElements()) {
            String key = (String)keyEnum.nextElement();
            Object value = formFields.get(key);
            if (value == null) continue;
            if (first) {
                first = false;
            } else {
                os.write(38);
            }
            os.write(key.getBytes("UTF-8"));
            os.write(61);
            os.write(value.toString().getBytes("UTF-8"));
        }
        os.close();
        byte[] result = os.toByteArray();
        if (VM.wouldLog(CLASS, 0)) {
            Enumeration keyEnum2 = formFields.keys();
            while (keyEnum2.hasMoreElements()) {
                String key = (String)keyEnum2.nextElement();
                String value = CMUrlHelper.decodeUrl((String)formFields.get(key));
                try {
                    if (value.startsWith("<") && !value.startsWith("<!") && !value.equals("<NONE>")) {
                        try {
                            VM.log(CLASS, 0, "form2bytes key: " + key + " value:\n" + DOM4JUtil.prettyPrint(value));
                        }
                        catch (Exception e) {
                            VM.log(CLASS, 0, "form2bytes key: " + key + " value:\n" + value);
                        }
                        continue;
                    }
                    VM.log(CLASS, 0, "form2bytes key: " + key + " value: " + value);
                }
                catch (Exception e) {
                    VM.log(CLASS, 0, "form2bytes key: " + key + " value: " + value);
                }
            }
        }
        return result;
    }

    private boolean isRedirectRequired(int statusCode) {
        switch (statusCode) {
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                return true;
            }
        }
        return false;
    }

    private void updateCookies(ICookieCallback cookieCallback, Cookie[] newCookies) {
        if (cookieCallback != null && newCookies != null) {
            Hashtable<String, String> cookiesStore = new Hashtable<String, String>();
            for (int i = 0; i < newCookies.length; ++i) {
                String name = newCookies[i].getName();
                String value = newCookies[i].getValue();
                cookiesStore.put(name, value);
                VM.log(CLASS, 0, "Updating cookie jar with cookie: " + name + " with value: " + value);
            }
            cookieCallback.updateCookies(cookiesStore);
        }
    }

    public InputStream create(String url, String parentPath, Hashtable cookies, Hashtable formFields) throws IOException {
        return this.create(url, parentPath, cookies, formFields, null, null);
    }

    protected final class HttpClientInputStreamFactory {
        protected HttpClientInputStreamFactory() {
        }

        private HttpClient createHttpClient(URL u) throws CAMCryptoException {
            HttpClient theClient = (HttpClient)InputStreamFactory.this.httpClient.get();
            theClient.setState(new HttpState());
            return theClient;
        }

        public void fetchHeaders(URL u, Hashtable<String, String> cognosCookies, IHTTPListener listener) {
            Throwable exc = null;
            HeadMethod hm = null;
            try {
                HttpClient hc = this.createHttpClient(u);
                hm = this.createHeadMethod(cognosCookies, u);
                int resultCode = hc.executeMethod((HttpMethod)hm);
                if (listener != null) {
                    listener.httpStatus(resultCode);
                }
                this.communicateResponseHeaders(hm.getResponseHeaders(), listener);
            }
            catch (CAMCryptoException cce) {
                exc = cce;
            }
            catch (HttpException hte) {
                exc = hte;
            }
            catch (IOException io) {
                exc = io;
            }
            catch (URISyntaxException use) {
                exc = use;
            }
            if (exc != null) {
                if (hm != null) {
                    hm.releaseConnection();
                }
                if (listener != null) {
                    listener.onException((Exception)exc);
                } else {
                    throw new RuntimeException(exc.getMessage(), exc);
                }
            }
        }

        private void communicateResponseHeaders(Header[] httpHeaders, IHTTPListener listener) {
            if (listener != null) {
                for (int i = 0; i < httpHeaders.length; ++i) {
                    listener.onHeader(httpHeaders[i].getName(), httpHeaders[i].getValue());
                }
            }
        }

        /*
         * Exception decompiling
         */
        public InputStream create(URL u, String parentPath, Hashtable<String, String> cognosCookies, Hashtable formFields, ICookieCallback cookieCallback, IHTTPListener listener) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [33[CATCHBLOCK]], but top level block is 16[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private InputStream redirectPostRequest(URL baseUrl, Hashtable<String, String> cognosCookies, HttpClient hc, PostMethod post, byte[] formData, ICookieCallback cookieCallback) throws IOException, MalformedURLException, HttpException, URISyntaxException {
            int status;
            int maxRedirects = hc.getParams().getIntParameter("http.protocol.max-redirects", 20);
            VM.log(CLASS, 0, "The maximum request redirects: " + maxRedirects);
            int redirectCount = 0;
            String redirectLocation = null;
            String oldRedirectLocation = null;
            do {
                Header locationHeader;
                if ((locationHeader = post.getResponseHeader("location")) != null) {
                    redirectLocation = locationHeader.getValue();
                }
                if (locationHeader == null || redirectLocation == null) {
                    throw new IOException("HttpClient invalide post redirection header!");
                }
                if (redirectLocation.equals(oldRedirectLocation) && redirectCount > 2) {
                    try {
                        Thread.sleep(1000 * redirectCount);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                oldRedirectLocation = redirectLocation;
                URL redirect = new URL(baseUrl, redirectLocation);
                post = this.createPostRequest(cognosCookies, redirect);
                post.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                post.setRequestBody((InputStream)new ByteArrayInputStream(formData));
                status = hc.executeMethod((HttpMethod)post);
                VM.log(CLASS, 0, "The request has been redirected (times): " + ++redirectCount);
                if (redirectCount > maxRedirects) {
                    throw new IOException("exceeded maxRedirects=" + maxRedirects);
                }
                try {
                    InputStreamFactory.this.updateCookies(cookieCallback, hc.getState().getCookies());
                }
                catch (Exception e) {
                    VM.log(CLASS, 0, "Updating cookies caused exception: " + e);
                }
            } while (InputStreamFactory.this.isRedirectRequired(status));
            return new HttpClientInputStream((HttpMethod)post);
        }

        private HeadMethod createHeadMethod(Hashtable<String, String> cognosCookies, URL u) throws MalformedURLException, URIException, UnsupportedEncodingException, URISyntaxException {
            HeadMethod head = new HeadMethod(InputStreamFactory.prepareUrl(u));
            this.insertCookies(cognosCookies, (HttpMethod)head, u);
            return head;
        }

        private GetMethod createGetRequest(Hashtable<String, String> cognosCookies, URL u) throws MalformedURLException, URIException, UnsupportedEncodingException, URISyntaxException {
            SEGetMethod get = new SEGetMethod(InputStreamFactory.prepareUrl(u));
            this.insertCookies(cognosCookies, (HttpMethod)get, u);
            return get;
        }

        void insertCookies(Hashtable<String, String> cookies, HttpMethod m, URL u) {
            if (this.isCognosURL(u) && cookies != null && cookies.size() > 0) {
                Enumeration<String> en = cookies.keys();
                String cookie = "";
                while (en.hasMoreElements()) {
                    String name = en.nextElement();
                    String value = cookies.get(name);
                    cookie = cookie + name + "=" + value + ";";
                    InputStreamFactory.logCookie("HttpClient " + m.getName(), name, value);
                }
                try {
                    VM.log(CLASS, 0, "Final cookie sent to " + m.getURI() + ": " + cookie);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                m.addRequestHeader("Cookie", cookie);
            }
        }

        private PostMethod createPostRequest(Hashtable<String, String> cognosCookies, URL u) throws MalformedURLException, URIException, UnsupportedEncodingException, URISyntaxException {
            String unencoded = URLDecoder.decode(u.toString(), "UTF-8");
            SEPostMethod post = new SEPostMethod(unencoded);
            this.insertCookies(cognosCookies, (HttpMethod)post, u);
            return post;
        }

        private boolean isCognosURL(URL u) {
            String targetHost = u.getHost();
            return targetHost.equals(InputStreamFactory.this.m_dispatcherURL.getHost()) || targetHost.equals(InputStreamFactory.this.m_gatewayURL.getHost());
        }
    }
}

