/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.standardedition;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;

public class JarHelper {
    private byte[] buffer;
    PrintStream verboseOut;

    public JarHelper() {
        this.verboseOut = null;
        this.buffer = new byte[4096];
    }

    public JarHelper(PrintStream verboseOut) {
        this.verboseOut = verboseOut;
        this.buffer = new byte[4096];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jarDirectory(String jarFile, String workingDir) throws IOException {
        FileOutputStream fos = new FileOutputStream(jarFile);
        JarOutputStream jos = new JarOutputStream(fos);
        File dir = new File(workingDir);
        if (!dir.exists()) {
            throw new IOException("directory not found: " + workingDir);
        }
        if (!dir.isDirectory()) {
            throw new IOException("not a directory: " + workingDir);
        }
        try {
            this.addDirectoryToJar(jos, "", dir);
        }
        finally {
            jos.close();
            fos.close();
        }
    }

    private void addDirectoryToJar(JarOutputStream jos, String path, File dir) throws IOException {
        if (!dir.isDirectory()) {
            return;
        }
        String[] children = dir.list();
        for (int i = 0; i < children.length; ++i) {
            File child = new File(dir.getCanonicalPath() + '/' + children[i]);
            if (child.isFile()) {
                this.addFileToJar(jos, path, child);
                continue;
            }
            if (!child.isDirectory()) continue;
            String subPath = path == null || path.length() == 0 ? children[i] : path + '/' + children[i];
            this.addDirectoryToJar(jos, subPath, child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileToJar(JarOutputStream jos, String path, File file) throws IOException {
        if (!file.isFile()) {
            return;
        }
        String pathInJar = path == null || path.length() == 0 ? file.getName() : path + '/' + file.getName();
        if (this.verboseOut != null) {
            this.verboseOut.println(" - " + pathInJar);
        }
        try (FileInputStream fis = new FileInputStream(file);){
            int byteCount;
            JarEntry je = new JarEntry(pathInJar);
            je.setTime(file.lastModified());
            jos.putNextEntry(je);
            while ((byteCount = fis.read(this.buffer)) != -1) {
                jos.write(this.buffer, 0, byteCount);
            }
            jos.flush();
            jos.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDirectoryToExistingJar(String existingJarFile, String outputJarFile, String workingDir) throws IOException {
        File jarFile = new File(outputJarFile);
        File tempFile = new File(existingJarFile);
        byte[] buf = new byte[2048];
        JarInputStream jin = new JarInputStream(new FileInputStream(tempFile));
        JarOutputStream out = new JarOutputStream(new FileOutputStream(jarFile));
        JarEntry entry = jin.getNextJarEntry();
        while (entry != null) {
            int len;
            String name = entry.getName();
            out.putNextEntry(new JarEntry(name));
            while ((len = jin.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            entry = jin.getNextJarEntry();
        }
        File dir = new File(workingDir);
        try {
            this.addDirectoryToJar(out, "", dir);
        }
        finally {
            out.close();
            jin.close();
        }
    }
}

