/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.standardedition;

import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.standardedition.StreamFlusherThread;
import java.io.File;
import java.io.IOException;

public class ProcessHelper {
    public static boolean isWindows() {
        return File.separatorChar == '\\';
    }

    public static int runProcess(String[] command, String workingDir) throws IOException {
        int rc = -1;
        System.err.println(workingDir + "> " + CMStringHelper.join(command, " "));
        Process process = Runtime.getRuntime().exec(command, null, new File(workingDir));
        ProcessHelper.flushProcessStreams(process);
        try {
            rc = process.waitFor();
        }
        catch (InterruptedException ex) {
            throw new IOException("command interrupted");
        }
        return rc;
    }

    public static int runProcess(String command, String workingDir) throws IOException {
        int rc = -1;
        System.err.println(workingDir + "> " + command);
        Process process = Runtime.getRuntime().exec(command, null, new File(workingDir));
        ProcessHelper.flushProcessStreams(process);
        try {
            rc = process.waitFor();
        }
        catch (InterruptedException ex) {
            throw new IOException("command interrupted");
        }
        return rc;
    }

    public static int runJavaProcess(String javaArgs, String workingDir) throws IOException {
        String javaPath = System.getProperty("_RUNJAVA");
        if ((javaPath == null || javaPath.length() == 0) && (javaPath = System.getProperty("JAVA_HOME")) != null) {
            javaPath = javaPath + "/bin/java";
            if (ProcessHelper.isWindows()) {
                javaPath = javaPath + ".exe";
            }
        }
        if (javaPath == null || javaPath.length() == 0) {
            javaPath = "java";
            if (ProcessHelper.isWindows()) {
                javaPath = javaPath + ".exe";
            }
        }
        javaPath = CMStringHelper.quoteStringLiteral(javaPath);
        String command = javaPath + " " + javaArgs;
        return ProcessHelper.runProcess(command, workingDir);
    }

    public static void flushProcessStreams(Process process) throws IOException {
        StreamFlusherThread flushOutThread = new StreamFlusherThread(process.getInputStream());
        StreamFlusherThread flushErrThread = new StreamFlusherThread(process.getErrorStream());
        flushOutThread.start();
        flushErrThread.start();
    }
}

