/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.standardedition;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.standardedition.RDSErrorXMLHandler;
import com.cognos.mobile.xml.IXMLParser;
import com.cognos.mobile.xml.XMLHelper;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RDSErrorSimplifier {
    private static final String SIGNATURE = "<rds:error";
    private static final String SIGNATURE2 = "<error";
    private static final String SIGNATURE3 = "</rds:error>";
    private static final String SIGNATURE4 = "</error>";
    private RDSErrorXMLHandler rdsErrorHandler = new RDSErrorXMLHandler();
    private static final Pattern p = Pattern.compile("([A-Z]{2,3}-[A-Z]{3}-[0-9]{4})([^<]*)<");

    public boolean canProcess(String message) throws CMException {
        return message.startsWith(SIGNATURE) && message.endsWith(SIGNATURE3) || message.startsWith(SIGNATURE2) && message.endsWith(SIGNATURE4);
    }

    public String process(String message) {
        ByteArrayInputStream stream;
        IXMLParser parser = new IXMLParser(){

            @Override
            public void parse(InputStream inputstream, DefaultHandler defaulthandler) throws SAXException, IOException {
                try {
                    SAXParserFactory.newInstance().newSAXParser().parse(inputstream, defaulthandler);
                }
                catch (ParserConfigurationException ex) {
                    throw new SAXException(ex);
                }
            }
        };
        try {
            stream = new ByteArrayInputStream(message.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        return this.process(parser, stream);
    }

    public String process(IXMLParser parser, InputStream stream) {
        try {
            this.rdsErrorHandler.doParse(parser, stream);
            StringBuffer sb = new StringBuffer();
            sb.append(this.rdsErrorHandler.getMessage() + "\n");
            String[] trace = RDSErrorSimplifier.simplifyTrace(this.rdsErrorHandler.getTrace());
            for (int i = 0; i < trace.length; ++i) {
                sb.append(XMLHelper.xmlDecode(trace[i]));
                if (trace[i].endsWith("\n")) continue;
                sb.append("\n");
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static String[] simplifyTrace(String trace) {
        if (trace == null) {
            return new String[0];
        }
        ArrayList<String> l = new ArrayList<String>();
        Matcher m = p.matcher(trace);
        while (m.find()) {
            l.add(m.group(1) + m.group(2));
        }
        return l.toArray(new String[l.size()]);
    }

    public static void main(String[] args) {
        IXMLParser parser = new IXMLParser(){

            @Override
            public void parse(InputStream inputstream, DefaultHandler defaulthandler) throws SAXException, IOException {
                try {
                    SAXParserFactory.newInstance().newSAXParser().parse(inputstream, defaulthandler);
                }
                catch (ParserConfigurationException ex) {
                    throw new SAXException(ex);
                }
            }
        };
        RDSErrorSimplifier sp = new RDSErrorSimplifier();
        try {
            String rv = sp.process(parser, new FileInputStream("c:/error.xml"));
            System.out.print(rv);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

